/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.handlers.addressing;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.RolePlayer;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.AddressingConstants;
import org.apache.axis2.addressing.AddressingFaultsHelper;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.addressing.EndpointReferenceHelper;
import org.apache.axis2.addressing.RelatesTo;
import org.apache.axis2.client.Options;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.LoggingControl;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AddressingInHandler
extends AbstractHandler
implements AddressingConstants {
    protected String addressingNamespace = "http://www.w3.org/2005/08/addressing";
    protected String addressingVersion = null;
    public static final String DISABLE_REF_PARAMETER_EXTRACT = "disableRefParamExtract";
    private static final Log log = LogFactory.getLog((Class)AddressingInHandler.class);
    private boolean disableRefparamExtract = false;
    protected static final int TO_FLAG = 1;
    protected static final int FROM_FLAG = 2;
    protected static final int REPLYTO_FLAG = 3;
    protected static final int FAULTO_FLAG = 4;
    protected static final int MESSAGEID_FLAG = 6;
    protected static final int ACTION_FLAG = 0;

    public void init(HandlerDescription handlerdesc) {
        super.init(handlerdesc);
        this.disableRefparamExtract = JavaUtils.isTrueExplicitly(Utils.getParameterValue(handlerdesc.getParameter(DISABLE_REF_PARAMETER_EXTRACT)));
        if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
            log.debug((Object)("AddressingInHandler.init disableRefparamExtract=" + this.disableRefparamExtract));
        }
    }

    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        Iterator iterator;
        if (JavaUtils.isTrueExplicitly(msgContext.getLocalProperty("IsAddressingProcessed"), false)) {
            if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                log.debug((Object)"Another handler has processed the addressing headers. Nothing to do here.");
            }
            return Handler.InvocationResponse.CONTINUE;
        }
        String namespace = (String)msgContext.getProperty("WSAddressingVersion");
        if (namespace == null) {
            namespace = this.addressingNamespace;
        } else if (!namespace.equals(this.addressingNamespace)) {
            if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                log.debug((Object)("This addressing handler does not match the specified namespace, " + namespace));
            }
            return Handler.InvocationResponse.CONTINUE;
        }
        SOAPHeader header = msgContext.getEnvelope().getHeader();
        RolePlayer rolePlayer = (RolePlayer)msgContext.getConfigurationContext().getAxisConfiguration().getParameterValue("rolePlayer");
        if (header == null) {
            msgContext.setProperty("disableAddressingForOutMessages", Boolean.TRUE);
            return Handler.InvocationResponse.CONTINUE;
        }
        if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
            log.debug((Object)("Starting " + this.addressingVersion + " IN handler ..."));
        }
        if ((iterator = header.getHeadersToProcess(rolePlayer, namespace)).hasNext()) {
            msgContext.setProperty("WSAddressingVersion", namespace);
            msgContext.setProperty("disableAddressingForOutMessages", Boolean.FALSE);
            if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                log.debug((Object)(this.addressingVersion + " Headers present in the SOAP message. Starting to process ..."));
            }
            if (this.extractAddressingInformation(header, msgContext, iterator, namespace)) {
                msgContext.setProperty("IsAddressingProcessed", Boolean.TRUE);
            }
        } else {
            msgContext.setProperty("disableAddressingForOutMessages", Boolean.TRUE);
            if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                log.debug((Object)("No Headers present corresponding to " + this.addressingVersion));
            }
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    protected boolean extractAddressingInformation(SOAPHeader header, MessageContext messageContext, Iterator headers, String namespace) throws AxisFault {
        Options messageContextOptions = messageContext.getOptions();
        ArrayList duplicateHeaderNames = new ArrayList(1);
        ArrayList<SOAPHeaderBlock> relatesToHeaders = null;
        SOAPHeaderBlock actionBlock = null;
        SOAPHeaderBlock toBlock = null;
        SOAPHeaderBlock messageIDBlock = null;
        SOAPHeaderBlock replyToBlock = null;
        SOAPHeaderBlock faultToBlock = null;
        SOAPHeaderBlock fromBlock = null;
        boolean[] ignoreHeaders = new boolean[7];
        boolean[] checkedHeaderNames = new boolean[7];
        while (headers.hasNext()) {
            SOAPHeaderBlock soapHeaderBlock = (SOAPHeaderBlock)headers.next();
            String localName = soapHeaderBlock.getLocalName();
            if ("Action".equals(localName)) {
                actionBlock = soapHeaderBlock;
                this.checkDuplicateHeaders("Action", 0, checkedHeaderNames, ignoreHeaders, duplicateHeaderNames);
                continue;
            }
            if ("To".equals(localName)) {
                toBlock = soapHeaderBlock;
                this.checkDuplicateHeaders("To", 1, checkedHeaderNames, ignoreHeaders, duplicateHeaderNames);
                continue;
            }
            if ("MessageID".equals(localName)) {
                messageIDBlock = soapHeaderBlock;
                this.checkDuplicateHeaders("MessageID", 6, checkedHeaderNames, ignoreHeaders, duplicateHeaderNames);
                continue;
            }
            if ("ReplyTo".equals(localName)) {
                replyToBlock = soapHeaderBlock;
                this.checkDuplicateHeaders("ReplyTo", 3, checkedHeaderNames, ignoreHeaders, duplicateHeaderNames);
                continue;
            }
            if ("FaultTo".equals(localName)) {
                faultToBlock = soapHeaderBlock;
                this.checkDuplicateHeaders("FaultTo", 4, checkedHeaderNames, ignoreHeaders, duplicateHeaderNames);
                continue;
            }
            if ("From".equals(localName)) {
                fromBlock = soapHeaderBlock;
                this.checkDuplicateHeaders("From", 2, checkedHeaderNames, ignoreHeaders, duplicateHeaderNames);
                continue;
            }
            if (!"RelatesTo".equals(localName)) continue;
            if (relatesToHeaders == null) {
                relatesToHeaders = new ArrayList<SOAPHeaderBlock>(1);
            }
            relatesToHeaders.add(soapHeaderBlock);
        }
        if (actionBlock == null && toBlock == null && messageIDBlock == null && replyToBlock == null && faultToBlock == null && fromBlock == null && relatesToHeaders == null) {
            return false;
        }
        if (actionBlock != null && !ignoreHeaders[0]) {
            this.extractActionInformation(actionBlock, messageContext);
        }
        if (toBlock != null && !ignoreHeaders[1]) {
            this.extractToEPRInformation(toBlock, messageContextOptions, header, namespace);
        }
        if (messageIDBlock != null && !ignoreHeaders[6]) {
            this.extractMessageIDInformation(messageIDBlock, messageContext);
        }
        if (relatesToHeaders != null) {
            for (int i = 0; i < relatesToHeaders.size(); ++i) {
                this.extractRelatesToInformation((SOAPHeaderBlock)relatesToHeaders.get(i), messageContextOptions);
            }
        }
        if (replyToBlock != null && !ignoreHeaders[3]) {
            this.extractReplyToEPRInformation(replyToBlock, namespace, messageContext);
        }
        if (faultToBlock != null && !ignoreHeaders[4]) {
            this.extractFaultToEPRInformation(faultToBlock, namespace, messageContext);
        }
        if (fromBlock != null && !ignoreHeaders[2]) {
            this.extractFromEPRInformation(fromBlock, namespace, messageContext);
        }
        if (!duplicateHeaderNames.isEmpty()) {
            AddressingFaultsHelper.triggerInvalidCardinalityFault(messageContext, (String)duplicateHeaderNames.get(0));
        }
        this.checkForMandatoryHeaders(checkedHeaderNames, messageContext);
        this.setDefaults(checkedHeaderNames, messageContext);
        return true;
    }

    protected boolean isInRole(SOAPHeaderBlock soapHeaderBlock, RolePlayer rolePlayer, boolean isSOAP11) {
        List roles;
        String role = soapHeaderBlock.getRole();
        if (role == null || role.equals("") || !isSOAP11 && role.equals("http://www.w3.org/2003/05/soap-envelope/role/ultimateReceiver")) {
            return rolePlayer == null || rolePlayer.isUltimateDestination();
        }
        if (role.equals(soapHeaderBlock.getVersion().getNextRoleURI())) {
            return true;
        }
        if (!isSOAP11 && role.equals("http://www.w3.org/2003/05/soap-envelope/role/none")) {
            return false;
        }
        List list = roles = rolePlayer == null ? null : rolePlayer.getRoles();
        if (roles != null) {
            for (int i = 0; i < roles.size(); ++i) {
                String thisRole = (String)roles.get(i);
                if (!thisRole.equals(role)) continue;
                return true;
            }
        }
        return false;
    }

    protected abstract void checkForMandatoryHeaders(boolean[] var1, MessageContext var2) throws AxisFault;

    protected abstract void setDefaults(boolean[] var1, MessageContext var2) throws AxisFault;

    private void checkDuplicateHeaders(String addressingHeaderName, int headerFlag, boolean[] checkedHeaderNames, boolean[] ignoreHeaders, ArrayList duplicateHeaderNames) {
        ignoreHeaders[headerFlag] = checkedHeaderNames[headerFlag];
        if (ignoreHeaders[headerFlag]) {
            duplicateHeaderNames.add(addressingHeaderName);
        } else {
            checkedHeaderNames[headerFlag] = true;
        }
        if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
            log.trace((Object)("checkDuplicateHeaders: addressingHeaderName=" + addressingHeaderName + " isDuplicate=" + ignoreHeaders[headerFlag]));
        }
    }

    protected abstract void extractToEprReferenceParameters(EndpointReference var1, SOAPHeader var2, String var3);

    private void extractRelatesToInformation(SOAPHeaderBlock soapHeaderBlock, Options messageContextOptions) {
        String relationshipTypeString;
        String address = soapHeaderBlock.getText();
        OMAttribute relationshipType = soapHeaderBlock.getAttribute(new QName("RelationshipType"));
        String string = relationshipTypeString = relationshipType == null ? null : relationshipType.getAttributeValue();
        if (log.isTraceEnabled()) {
            log.trace((Object)("extractRelatesToInformation: Extracted Relationship. Value=" + address + " RelationshipType=" + relationshipTypeString));
        }
        RelatesTo relatesTo = new RelatesTo(address, relationshipTypeString);
        ArrayList attributes = this.extractAttributesFromSOAPHeaderBlock(soapHeaderBlock);
        relatesTo.setExtensibilityAttributes(attributes);
        messageContextOptions.addRelatesTo(relatesTo);
        soapHeaderBlock.setProcessed();
    }

    private void extractFaultToEPRInformation(SOAPHeaderBlock soapHeaderBlock, String addressingNamespace, MessageContext messageContext) throws AxisFault {
        Options messageContextOptions = messageContext.getOptions();
        EndpointReference epr = messageContextOptions.getFaultTo();
        if (epr == null) {
            epr = new EndpointReference("");
            messageContextOptions.setFaultTo(epr);
        }
        this.extractEPRInformation(soapHeaderBlock, epr, addressingNamespace, messageContext);
        if (log.isTraceEnabled()) {
            log.trace((Object)("extractFaultToEPRInformation: Extracted FaultTo EPR: " + epr));
        }
        soapHeaderBlock.setProcessed();
    }

    private void extractReplyToEPRInformation(SOAPHeaderBlock soapHeaderBlock, String addressingNamespace, MessageContext messageContext) throws AxisFault {
        Options messageContextOptions = messageContext.getOptions();
        EndpointReference epr = messageContextOptions.getReplyTo();
        if (epr == null) {
            epr = new EndpointReference("");
            messageContextOptions.setReplyTo(epr);
        }
        this.extractEPRInformation(soapHeaderBlock, epr, addressingNamespace, messageContext);
        if (log.isTraceEnabled()) {
            log.trace((Object)("extractReplyToEPRInformation: Extracted ReplyTo EPR: " + epr));
        }
        soapHeaderBlock.setProcessed();
    }

    private void extractFromEPRInformation(SOAPHeaderBlock soapHeaderBlock, String addressingNamespace, MessageContext messageContext) throws AxisFault {
        Options messageContextOptions = messageContext.getOptions();
        EndpointReference epr = messageContextOptions.getFrom();
        if (epr == null) {
            epr = new EndpointReference("");
            messageContextOptions.setFrom(epr);
        }
        this.extractEPRInformation(soapHeaderBlock, epr, addressingNamespace, messageContext);
        if (log.isTraceEnabled()) {
            log.trace((Object)("extractFromEPRInformation: Extracted From EPR: " + epr));
        }
        soapHeaderBlock.setProcessed();
    }

    private void extractToEPRInformation(SOAPHeaderBlock soapHeaderBlock, Options messageContextOptions, SOAPHeader header, String namespace) {
        EndpointReference epr = new EndpointReference(soapHeaderBlock.getText());
        messageContextOptions.setTo(epr);
        Iterator addressAttributes = soapHeaderBlock.getAllAttributes();
        if (addressAttributes != null && addressAttributes.hasNext()) {
            ArrayList<OMAttribute> attributes = new ArrayList<OMAttribute>();
            while (addressAttributes.hasNext()) {
                OMAttribute attr = (OMAttribute)addressAttributes.next();
                attributes.add(attr);
            }
            epr.setAddressAttributes(attributes);
        }
        if (!this.disableRefparamExtract) {
            this.extractToEprReferenceParameters(epr, header, namespace);
        }
        soapHeaderBlock.setProcessed();
        if (log.isTraceEnabled()) {
            log.trace((Object)("extractToEPRInformation: Extracted To EPR: " + epr));
        }
    }

    private void extractActionInformation(SOAPHeaderBlock soapHeaderBlock, MessageContext messageContext) throws AxisFault {
        ArrayList attributes;
        Options messageContextOptions = messageContext.getOptions();
        String soapAction = messageContextOptions.getAction();
        String wsaAction = soapHeaderBlock.getText();
        if (log.isTraceEnabled()) {
            log.trace((Object)("extractActionInformation: soapAction='" + soapAction + "' wsa:Action='" + wsaAction + "'"));
        }
        if (wsaAction == null || "".equals(wsaAction.trim())) {
            AddressingFaultsHelper.triggerActionNotSupportedFault(messageContext, wsaAction);
        }
        if (soapAction != null && !"".equals(soapAction) && messageContext.isServerSide()) {
            if (!soapAction.equals(wsaAction)) {
                AddressingFaultsHelper.triggerActionMismatchFault(messageContext, soapAction, wsaAction);
            }
        } else {
            messageContextOptions.setAction(wsaAction);
        }
        if ((attributes = this.extractAttributesFromSOAPHeaderBlock(soapHeaderBlock)) != null) {
            messageContext.setProperty("actionAttributes", attributes);
        }
        soapHeaderBlock.setProcessed();
    }

    private void extractMessageIDInformation(SOAPHeaderBlock soapHeaderBlock, MessageContext messageContext) throws AxisFault {
        messageContext.getOptions().setMessageId(soapHeaderBlock.getText());
        ArrayList attributes = this.extractAttributesFromSOAPHeaderBlock(soapHeaderBlock);
        if (attributes != null) {
            messageContext.setProperty("messageidAttributes", attributes);
        }
        soapHeaderBlock.setProcessed();
    }

    private void extractEPRInformation(SOAPHeaderBlock headerBlock, EndpointReference epr, String addressingNamespace, MessageContext messageContext) throws AxisFault {
        try {
            EndpointReferenceHelper.fromOM(epr, (OMElement)headerBlock, addressingNamespace);
        }
        catch (AxisFault af) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"extractEPRInformation: Exception occurred deserialising an EndpointReference.", (Throwable)af);
            }
            AddressingFaultsHelper.triggerMissingAddressInEPRFault(messageContext, headerBlock.getLocalName());
        }
    }

    private ArrayList extractAttributesFromSOAPHeaderBlock(SOAPHeaderBlock soapHeaderBlock) {
        Iterator actionAttributes = soapHeaderBlock.getAllAttributes();
        if (actionAttributes != null && actionAttributes.hasNext()) {
            ArrayList<OMAttribute> attributes = new ArrayList<OMAttribute>();
            while (actionAttributes.hasNext()) {
                OMAttribute attr = (OMAttribute)actionAttributes.next();
                attributes.add(attr);
            }
            return attributes;
        }
        return null;
    }
}

