/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.handlers.addressing;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.AddressingFaultsHelper;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.handlers.addressing.AddressingInHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AddressingFinalInHandler
extends AddressingInHandler {
    private static final Log log = LogFactory.getLog((Class)AddressingFinalInHandler.class);

    public AddressingFinalInHandler() {
        this.addressingNamespace = "http://www.w3.org/2005/08/addressing";
        this.addressingVersion = "WS-Addressing Final";
    }

    protected void extractToEprReferenceParameters(EndpointReference toEPR, SOAPHeader header, String namespace) {
        Iterator headerBlocks = header.getChildElements();
        while (headerBlocks.hasNext()) {
            OMElement headerElement = (OMElement)headerBlocks.next();
            OMAttribute isRefParamAttr = headerElement.getAttribute(new QName(namespace, "IsReferenceParameter"));
            if (log.isTraceEnabled()) {
                log.trace((Object)("extractToEprReferenceParameters: Checking header: " + headerElement.getQName()));
            }
            if (isRefParamAttr == null || !"true".equals(isRefParamAttr.getAttributeValue())) continue;
            toEPR.addReferenceParameter(headerElement);
            if (!log.isTraceEnabled()) continue;
            log.trace((Object)("extractToEprReferenceParameters: Header: " + headerElement.getQName() + " has IsReferenceParameter attribute. Adding to toEPR."));
        }
    }

    protected void checkForMandatoryHeaders(boolean[] alreadyFoundAddrHeader, MessageContext messageContext) throws AxisFault {
        if (!alreadyFoundAddrHeader[0]) {
            AddressingFaultsHelper.triggerMessageAddressingRequiredFault(messageContext, "Action");
        }
    }

    protected void setDefaults(boolean[] alreadyFoundAddrHeader, MessageContext messageContext) {
        if (!alreadyFoundAddrHeader[1] && !messageContext.isServerSide()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)(messageContext.getLogIDString() + " setDefaults: Setting WS-Addressing default value for the To property."));
            }
            messageContext.setTo(new EndpointReference("http://www.w3.org/2005/08/addressing/anonymous"));
        }
        if (!alreadyFoundAddrHeader[3]) {
            messageContext.setReplyTo(new EndpointReference("http://www.w3.org/2005/08/addressing/anonymous"));
            if (log.isTraceEnabled()) {
                log.trace((Object)(messageContext.getLogIDString() + " setDefaults: Setting WS-Addressing default value for the ReplyTo property."));
            }
        }
    }
}

