/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.PolicyInclude;
import org.apache.neethi.PolicyRegistry;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.resolver.URIResolver;
import org.w3c.dom.Element;

public abstract class WSDLToAxisServiceBuilder {
    protected static final String XMLSCHEMA_NAMESPACE_URI = "http://www.w3.org/2001/XMLSchema";
    protected static final String XMLSCHEMA_NAMESPACE_PREFIX = "xs";
    protected static final String XML_SCHEMA_LOCAL_NAME = "schema";
    protected static final String XML_SCHEMA_SEQUENCE_LOCAL_NAME = "sequence";
    protected static final String XML_SCHEMA_COMPLEX_TYPE_LOCAL_NAME = "complexType";
    protected static final String XML_SCHEMA_ELEMENT_LOCAL_NAME = "element";
    protected static final String XML_SCHEMA_IMPORT_LOCAL_NAME = "import";
    protected static final String XSD_NAME = "name";
    protected static final String XSD_TARGETNAMESPACE = "targetNamespace";
    protected static final String XMLNS_AXIS2WRAPPED = "xmlns:axis2wrapped";
    protected static final String AXIS2WRAPPED = "axis2wrapped";
    protected static final String XSD_TYPE = "type";
    protected static final String XSD_REF = "ref";
    protected static int nsCount = 0;
    protected Map resolvedRpcWrappedElementMap = new HashMap();
    protected static final String XSD_ELEMENT_FORM_DEFAULT = "elementFormDefault";
    protected static final String XSD_UNQUALIFIED = "unqualified";
    protected InputStream in;
    protected AxisService axisService;
    protected PolicyRegistry registry;
    protected QName serviceName;
    protected boolean isServerSide = true;
    protected String style = null;
    private URIResolver customResolver;
    private String baseUri = null;
    protected static final String TYPES = "Types";
    protected boolean isCodegen;

    protected WSDLToAxisServiceBuilder() {
    }

    public WSDLToAxisServiceBuilder(InputStream in, QName serviceName) {
        this.in = in;
        this.serviceName = serviceName;
        this.axisService = new AxisService();
        this.setPolicyRegistryFromService(this.axisService);
    }

    public WSDLToAxisServiceBuilder(InputStream in, AxisService axisService) {
        this.in = in;
        this.axisService = axisService;
        this.setPolicyRegistryFromService(axisService);
    }

    public void setCustomResolver(URIResolver customResolver) {
        this.customResolver = customResolver;
    }

    public boolean isServerSide() {
        return this.isServerSide;
    }

    public void setServerSide(boolean serverSide) {
        this.isServerSide = serverSide;
    }

    protected void setPolicyRegistryFromService(AxisService axisService) {
        PolicyInclude policyInclude = axisService.getPolicyInclude();
        this.registry = policyInclude.getPolicyRegistry();
    }

    protected XmlSchema getXMLSchema(Element element, String baseUri) {
        XmlSchemaCollection schemaCollection = new XmlSchemaCollection();
        if (baseUri != null) {
            schemaCollection.setBaseUri(baseUri);
        }
        if (this.customResolver != null) {
            schemaCollection.setSchemaResolver(this.customResolver);
        }
        return schemaCollection.read(element);
    }

    protected String findSchemaPrefix() {
        String xsdPrefix = null;
        Map declaredNameSpaces = this.axisService.getNamespaceMap();
        if (declaredNameSpaces.containsValue(XMLSCHEMA_NAMESPACE_URI)) {
            Iterator it = declaredNameSpaces.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                if (!XMLSCHEMA_NAMESPACE_URI.equals(declaredNameSpaces.get(key))) continue;
                xsdPrefix = key;
                break;
            }
        } else {
            xsdPrefix = XMLSCHEMA_NAMESPACE_PREFIX;
        }
        return xsdPrefix;
    }

    public abstract AxisService populateService() throws AxisFault;

    protected DocumentBuilder getDOMDocumentBuilder() {
        DocumentBuilder documentBuilder;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        return documentBuilder;
    }

    protected String getTemporaryNamespacePrefix() {
        return "ns" + nsCount++;
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public void setBaseUri(String baseUri) {
        this.baseUri = baseUri;
    }

    public boolean isCodegen() {
        return this.isCodegen;
    }

    public void setCodegen(boolean codegen) {
        this.isCodegen = codegen;
    }

    public QName getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(QName serviceName) {
        this.serviceName = serviceName;
    }

    protected static String stackToString() {
        return WSDLToAxisServiceBuilder.stackToString(new RuntimeException());
    }

    protected static String stackToString(Throwable e) {
        StringWriter sw = new StringWriter();
        BufferedWriter bw = new BufferedWriter(sw);
        PrintWriter pw = new PrintWriter(bw);
        e.printStackTrace(pw);
        pw.close();
        String text = sw.getBuffer().toString();
        text = text.substring(text.indexOf("at"));
        text = WSDLToAxisServiceBuilder.replace(text, "at ", "DEBUG_FRAME = ");
        return text;
    }

    protected static final String replace(String name, String oldT, String newT) {
        if (name == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer(name.length() * 2);
        int len = oldT.length();
        try {
            int start = 0;
            int i = name.indexOf(oldT, start);
            while (i >= 0) {
                sb.append(name.substring(start, i));
                sb.append(newT);
                start = i + len;
                i = name.indexOf(oldT, start);
            }
            if (start < name.length()) {
                sb.append(name.substring(start));
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        return new String(sb);
    }
}

