/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.AxisFault;
import org.apache.axis2.Constants;
import org.apache.axis2.addressing.AddressingHelper;
import org.apache.axis2.description.AxisBinding;
import org.apache.axis2.description.AxisEndpoint;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.WSDL2Constants;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.WSDLSerializationUtil;
import org.apache.axis2.util.XMLUtils;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaObjectCollection;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaType;

public class AxisService2WSDL20
implements WSDL2Constants {
    private AxisService axisService;
    private String serviceName;
    private String[] eprs = null;
    private OMNamespace wsaw;

    public AxisService2WSDL20(AxisService service) {
        this.axisService = service;
        this.serviceName = service.getName();
    }

    public AxisService2WSDL20(AxisService service, String serviceName) {
        this.axisService = service;
        this.serviceName = serviceName;
    }

    public OMElement generateOM() throws Exception {
        Map nameSpacesMap = this.axisService.getNamespaceMap();
        OMFactory omFactory = OMAbstractFactory.getOMFactory();
        OMNamespace wsdl = nameSpacesMap != null && nameSpacesMap.containsValue("http://www.w3.org/ns/wsdl") ? omFactory.createOMNamespace("http://www.w3.org/ns/wsdl", WSDLSerializationUtil.getPrefix("http://www.w3.org/ns/wsdl", nameSpacesMap)) : omFactory.createOMNamespace("http://www.w3.org/ns/wsdl", "wsdl2");
        OMElement descriptionElement = omFactory.createOMElement("description", wsdl);
        WSDLSerializationUtil.populateNamespaces(descriptionElement, nameSpacesMap);
        descriptionElement.declareNamespace(this.axisService.getTargetNamespace(), this.axisService.getTargetNamespacePrefix());
        this.wsaw = descriptionElement.declareNamespace("http://www.w3.org/2006/05/addressing/wsdl", "wsaw");
        OMAttribute targetNamespace = omFactory.createOMAttribute("targetNamespace", null, this.axisService.getTargetNamespace());
        descriptionElement.addAttribute(targetNamespace);
        OMNamespace tns = omFactory.createOMNamespace(this.axisService.getTargetNamespace(), this.axisService.getTargetNamespacePrefix());
        OMNamespace wsoap = nameSpacesMap != null && nameSpacesMap.containsValue("http://www.w3.org/ns/wsdl/soap") ? omFactory.createOMNamespace("http://www.w3.org/ns/wsdl/soap", WSDLSerializationUtil.getPrefix("http://www.w3.org/ns/wsdl/soap", nameSpacesMap)) : descriptionElement.declareNamespace("http://www.w3.org/ns/wsdl/soap", "wsoap");
        OMNamespace whttp = nameSpacesMap != null && nameSpacesMap.containsValue("http://www.w3.org/ns/wsdl/http") ? omFactory.createOMNamespace("http://www.w3.org/ns/wsdl/http", WSDLSerializationUtil.getPrefix("http://www.w3.org/ns/wsdl/http", nameSpacesMap)) : descriptionElement.declareNamespace("http://www.w3.org/ns/wsdl/http", "whttp");
        OMNamespace wsdlx = nameSpacesMap != null && nameSpacesMap.containsValue("http://www.w3.org/ns/wsdl-extensions") ? omFactory.createOMNamespace("http://www.w3.org/ns/wsdl-extensions", WSDLSerializationUtil.getPrefix("http://www.w3.org/ns/wsdl-extensions", nameSpacesMap)) : descriptionElement.declareNamespace("http://www.w3.org/ns/wsdl-extensions", "wsdlx");
        OMNamespace wrpc = nameSpacesMap != null && nameSpacesMap.containsValue("http://www.w3.org/ns/wsdl/rpc") ? omFactory.createOMNamespace("http://www.w3.org/ns/wsdl/rpc", WSDLSerializationUtil.getPrefix("http://www.w3.org/ns/wsdl/rpc", nameSpacesMap)) : descriptionElement.declareNamespace("http://www.w3.org/ns/wsdl/rpc", "wrpc");
        WSDLSerializationUtil.addWSDLDocumentationElement(this.axisService, descriptionElement, omFactory, wsdl);
        OMElement typesElement = omFactory.createOMElement("types", wsdl);
        this.axisService.populateSchemaMappings();
        ArrayList schemas = this.axisService.getSchema();
        for (int i = 0; i < schemas.size(); ++i) {
            StringWriter writer = new StringWriter();
            XmlSchema schema = this.axisService.getSchema(i);
            if ("http://www.w3.org/2001/XMLSchema".equals(schema.getTargetNamespace())) continue;
            schema.write((Writer)writer);
            String schemaString = writer.toString();
            if ("".equals(schemaString)) continue;
            try {
                typesElement.addChild(XMLUtils.toOM(new ByteArrayInputStream(schemaString.getBytes())));
                continue;
            }
            catch (XMLStreamException e) {
                throw AxisFault.makeFault(e);
            }
        }
        descriptionElement.addChild((OMNode)typesElement);
        Parameter parameter = this.axisService.getParameter("interface");
        String interfaceName = parameter != null ? (String)parameter.getValue() : "ServiceInterface";
        descriptionElement.addChild((OMNode)this.getInterfaceElement(wsdl, tns, wsdlx, wrpc, omFactory, interfaceName));
        boolean disableREST = false;
        Parameter disableRESTParameter = this.axisService.getParameter("disableREST");
        if (disableRESTParameter != null && JavaUtils.isTrueExplicitly(disableRESTParameter.getValue())) {
            disableREST = true;
        }
        boolean disableSOAP12 = false;
        Parameter disableSOAP12Parameter = this.axisService.getParameter("disableSOAP12");
        if (disableSOAP12Parameter != null && JavaUtils.isTrueExplicitly(disableSOAP12Parameter.getValue())) {
            disableSOAP12 = true;
        }
        HashSet<AxisBinding> bindings = new HashSet<AxisBinding>();
        Map endpointMap = this.axisService.getEndpoints();
        if (endpointMap != null && endpointMap.size() > 0) {
            String[] eprs = this.axisService.getEPRs();
            if (eprs == null) {
                eprs = new String[]{this.serviceName};
            }
            OMElement serviceElement = this.getServiceElement(wsdl, tns, omFactory, interfaceName);
            Iterator iterator = endpointMap.values().iterator();
            while (iterator.hasNext()) {
                String propertySOAPVersion;
                AxisEndpoint axisEndpoint = (AxisEndpoint)iterator.next();
                AxisBinding axisBinding = axisEndpoint.getBinding();
                String type = axisBinding.getType();
                if ("http://www.w3.org/ns/wsdl/http".equals(type) && disableREST || "http://www.w3.org/2003/05/soap-envelope".equals(propertySOAPVersion = (String)axisBinding.getProperty("wsoap:version")) && disableSOAP12) continue;
                bindings.add(axisBinding);
                for (int i = 0; i < eprs.length; ++i) {
                    String epr = eprs[i];
                    OMElement endpointElement = axisEndpoint.toWSDL20(wsdl, tns, whttp, epr);
                    boolean endpointAlreadyAdded = false;
                    Iterator endpointsAdded = serviceElement.getChildren();
                    while (endpointsAdded.hasNext()) {
                        OMElement endpoint = (OMElement)endpointsAdded.next();
                        if (!endpoint.getAttribute(new QName("binding")).getAttributeValue().equals(endpointElement.getAttribute(new QName("binding")).getAttributeValue()) || !endpoint.getAttribute(new QName("address")).getAttributeValue().equals(endpointElement.getAttribute(new QName("address")).getAttributeValue())) continue;
                        endpointAlreadyAdded = true;
                    }
                    if (endpointAlreadyAdded) continue;
                    serviceElement.addChild((OMNode)endpointElement);
                }
            }
            Iterator iter = bindings.iterator();
            while (iter.hasNext()) {
                AxisBinding binding = (AxisBinding)iter.next();
                descriptionElement.addChild((OMNode)binding.toWSDL20(wsdl, tns, wsoap, whttp, interfaceName, this.axisService.getNamespaceMap(), AddressingHelper.getAddressingRequirementParemeterValue(this.axisService), this.serviceName, this.wsaw));
            }
            descriptionElement.addChild((OMNode)serviceElement);
        } else {
            descriptionElement.addChild((OMNode)WSDLSerializationUtil.generateSOAP11Binding(omFactory, this.axisService, wsdl, wsoap, tns, this.serviceName));
            if (!disableSOAP12) {
                descriptionElement.addChild((OMNode)WSDLSerializationUtil.generateSOAP12Binding(omFactory, this.axisService, wsdl, wsoap, tns, this.serviceName));
            }
            if (!disableREST) {
                descriptionElement.addChild((OMNode)WSDLSerializationUtil.generateHTTPBinding(omFactory, this.axisService, wsdl, whttp, tns, this.serviceName));
            }
            descriptionElement.addChild((OMNode)WSDLSerializationUtil.generateServiceElement(omFactory, wsdl, tns, this.axisService, disableREST, disableSOAP12, this.eprs, this.serviceName));
        }
        return descriptionElement;
    }

    private OMElement getInterfaceElement(OMNamespace wsdl, OMNamespace tns, OMNamespace wsdlx, OMNamespace wrpc, OMFactory fac, String interfaceName) throws URISyntaxException, AxisFault {
        OMElement interfaceElement = fac.createOMElement("interface", wsdl);
        interfaceElement.addAttribute(fac.createOMAttribute("name", null, interfaceName));
        Iterator iterator = this.axisService.getOperations();
        ArrayList<OMElement> interfaceOperations = new ArrayList<OMElement>();
        ArrayList<String> interfaceFaults = new ArrayList<String>();
        int i = 0;
        while (iterator.hasNext()) {
            AxisOperation axisOperation = (AxisOperation)iterator.next();
            if (axisOperation.isControlOperation()) continue;
            interfaceOperations.add(i, this.generateInterfaceOperationElement(axisOperation, wsdl, tns, wsdlx, wrpc));
            ++i;
            Iterator faultsIterator = axisOperation.getFaultMessages().iterator();
            while (faultsIterator.hasNext()) {
                AxisMessage faultMessage = (AxisMessage)faultsIterator.next();
                String name = faultMessage.getName();
                if (interfaceFaults.contains(name)) continue;
                OMElement faultElement = fac.createOMElement("fault", wsdl);
                faultElement.addAttribute(fac.createOMAttribute("name", null, name));
                faultElement.addAttribute(fac.createOMAttribute("element", null, WSDLSerializationUtil.getElementName(faultMessage, this.axisService.getNamespaceMap())));
                interfaceFaults.add(name);
                interfaceElement.addChild((OMNode)faultElement);
            }
        }
        for (i = 0; i < interfaceOperations.size(); ++i) {
            interfaceElement.addChild((OMNode)interfaceOperations.get(i));
        }
        return interfaceElement;
    }

    private OMElement getServiceElement(OMNamespace wsdl, OMNamespace tns, OMFactory omFactory, String interfaceName) {
        OMElement serviceElement = omFactory.createOMElement("service", wsdl);
        serviceElement.addAttribute(omFactory.createOMAttribute("name", null, this.serviceName));
        serviceElement.addAttribute(omFactory.createOMAttribute("interface", null, tns.getPrefix() + ":" + interfaceName));
        return serviceElement;
    }

    public OMElement generateInterfaceOperationElement(AxisOperation axisOperation, OMNamespace wsdl, OMNamespace tns, OMNamespace wsdlx, OMNamespace wrpc) throws URISyntaxException, AxisFault {
        ArrayList faults;
        AxisMessage outMessage;
        OMFactory omFactory = OMAbstractFactory.getOMFactory();
        OMElement axisOperationElement = omFactory.createOMElement("operation", wsdl);
        WSDLSerializationUtil.addWSDLDocumentationElement(axisOperation, axisOperationElement, omFactory, wsdl);
        axisOperationElement.addAttribute(omFactory.createOMAttribute("name", null, axisOperation.getName().getLocalPart()));
        URI[] opStyle = (URI[])axisOperation.getParameterValue("operationStyle");
        if (opStyle == null) {
            opStyle = this.checkStyle(axisOperation);
            Parameter opStyleParameter = new Parameter();
            opStyleParameter.setName("operationStyle");
            opStyleParameter.setValue(opStyle);
            axisOperation.addParameter(opStyleParameter);
        }
        if (opStyle != null && opStyle.length > 0) {
            String style = opStyle[0].toString();
            for (int i = 1; i < opStyle.length; ++i) {
                URI uri = opStyle[i];
                style = style + " " + uri;
            }
            axisOperationElement.addAttribute(omFactory.createOMAttribute("style", null, style));
            if (style.indexOf("http://www.w3.org/ns/wsdl/style/rpc") >= 0) {
                axisOperationElement.addAttribute(omFactory.createOMAttribute("signature", wrpc, (String)axisOperation.getParameterValue("wrpc:signature")));
            }
        }
        axisOperationElement.addAttribute(omFactory.createOMAttribute("pattern", null, axisOperation.getMessageExchangePattern()));
        Parameter param = axisOperation.getParameter("wsdlx:safe");
        if (param != null) {
            axisOperationElement.addAttribute(omFactory.createOMAttribute("safe", wsdlx, param.getValue().toString()));
        }
        AxisService axisService = axisOperation.getAxisService();
        Map nameSpaceMap = axisService.getNamespaceMap();
        AxisMessage inMessage = (AxisMessage)axisOperation.getChild("inMessage");
        if (inMessage != null) {
            OMElement inMessageElement = omFactory.createOMElement("input", wsdl);
            inMessageElement.addAttribute(omFactory.createOMAttribute("element", null, WSDLSerializationUtil.getElementName(inMessage, nameSpaceMap)));
            WSDLSerializationUtil.addWSAWActionAttribute(inMessageElement, axisOperation.getInputAction(), this.wsaw);
            WSDLSerializationUtil.addWSDLDocumentationElement(inMessage, inMessageElement, omFactory, wsdl);
            axisOperationElement.addChild((OMNode)inMessageElement);
        }
        if ((outMessage = (AxisMessage)axisOperation.getChild("outMessage")) != null) {
            OMElement outMessageElement = omFactory.createOMElement("output", wsdl);
            outMessageElement.addAttribute(omFactory.createOMAttribute("element", null, WSDLSerializationUtil.getElementName(outMessage, nameSpaceMap)));
            WSDLSerializationUtil.addWSAWActionAttribute(outMessageElement, axisOperation.getOutputAction(), this.wsaw);
            WSDLSerializationUtil.addWSDLDocumentationElement(outMessage, outMessageElement, omFactory, wsdl);
            axisOperationElement.addChild((OMNode)outMessageElement);
        }
        if ((faults = axisOperation.getFaultMessages()) != null) {
            Iterator iterator = faults.iterator();
            while (iterator.hasNext()) {
                AxisMessage faultMessage = (AxisMessage)iterator.next();
                OMElement faultElement = "in".equals(faultMessage.getDirection()) ? omFactory.createOMElement("infault", wsdl) : omFactory.createOMElement("outfault", wsdl);
                faultElement.addAttribute(omFactory.createOMAttribute("ref", null, tns.getPrefix() + ":" + faultMessage.getName()));
                WSDLSerializationUtil.addWSAWActionAttribute(faultElement, axisOperation.getFaultAction(faultMessage.getName()), this.wsaw);
                WSDLSerializationUtil.addWSDLDocumentationElement(faultMessage, faultElement, omFactory, wsdl);
                axisOperationElement.addChild((OMNode)faultElement);
            }
        }
        return axisOperationElement;
    }

    public void setEPRs(String[] eprs) {
        this.eprs = eprs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private URI[] checkStyle(AxisOperation axisOperation) throws URISyntaxException, AxisFault {
        boolean isRPC = true;
        boolean isMultipart = true;
        boolean isIRI = true;
        ArrayList<URI> styles = new ArrayList<URI>(3);
        String mep = axisOperation.getMessageExchangePattern();
        if (!"http://www.w3.org/ns/wsdl/in-only".equals(mep) && !"http://www.w3.org/ns/wsdl/in-out".equals(mep)) {
            isRPC = false;
        }
        LinkedHashMap<String, QName> inMessageElementDetails = new LinkedHashMap<String, QName>();
        AxisMessage inMessage = axisOperation.getMessage("In");
        if (inMessage == null) return new URI[0];
        QName qName = inMessage.getElementQName();
        if (qName == null || Constants.XSD_ANY.equals(qName)) {
            return new URI[0];
        }
        XmlSchemaElement schemaElement = inMessage.getSchemaElement();
        if (schemaElement == null) return new URI[0];
        if (!axisOperation.getName().getLocalPart().equals(schemaElement.getName())) {
            return new URI[0];
        }
        QName inMessageElementQname = schemaElement.getQName();
        XmlSchemaType type = schemaElement.getSchemaType();
        if (type == null || !(type instanceof XmlSchemaComplexType)) return new URI[0];
        XmlSchemaComplexType complexType = (XmlSchemaComplexType)type;
        XmlSchemaParticle particle = complexType.getParticle();
        if (particle == null || !(particle instanceof XmlSchemaSequence)) return new URI[0];
        XmlSchemaSequence xmlSchemaSequence = (XmlSchemaSequence)particle;
        XmlSchemaObjectCollection schemaObjectCollection = xmlSchemaSequence.getItems();
        if (schemaObjectCollection != null) {
            Iterator iterator = schemaObjectCollection.getIterator();
            while (iterator.hasNext()) {
                String name;
                Object next = iterator.next();
                if (!(next instanceof XmlSchemaElement)) {
                    return new URI[0];
                }
                XmlSchemaElement innerElement = (XmlSchemaElement)next;
                if (innerElement.getRefName() != null) {
                    return new URI[0];
                }
                if (innerElement.getMinOccurs() != 1L || innerElement.getMaxOccurs() != 1L) {
                    isMultipart = false;
                }
                XmlSchemaType schemaType = innerElement.getSchemaType();
                QName innerElementQName = innerElement.getSchemaTypeName();
                if (schemaType instanceof XmlSchemaSimpleType) {
                    if (Constants.XSD_QNAME.equals(innerElementQName) || Constants.XSD_NOTATION.equals(innerElementQName) || Constants.XSD_HEXBIN.equals(innerElementQName) || Constants.XSD_BASE64.equals(innerElementQName)) {
                        isIRI = false;
                    }
                } else {
                    isIRI = false;
                }
                if (Constants.XSD_ANY.equals(innerElementQName) && iterator.hasNext()) {
                    isRPC = false;
                }
                if (inMessageElementDetails.get(name = innerElement.getName()) != null) {
                    isRPC = false;
                    isMultipart = false;
                }
                inMessageElementDetails.put(name, innerElementQName);
            }
        }
        AxisMessage outMessage = null;
        LinkedHashMap<String, QName> outMessageElementDetails = new LinkedHashMap<String, QName>();
        if (isRPC && !"http://www.w3.org/ns/wsdl/in-only".equals(mep)) {
            XmlSchemaElement schemaElement2;
            outMessage = axisOperation.getMessage("Out");
            QName qName2 = outMessage.getElementQName();
            if (qName2 == null && Constants.XSD_ANY.equals(qName2)) {
                isRPC = false;
            }
            if ((schemaElement2 = outMessage.getSchemaElement()) != null) {
                XmlSchemaType type2;
                if (!(axisOperation.getName().getLocalPart() + "Response").equals(schemaElement2.getName())) {
                    isRPC = false;
                }
                if (!schemaElement2.getQName().getNamespaceURI().equals(inMessageElementQname.getNamespaceURI())) {
                    isRPC = false;
                }
                if ((type2 = schemaElement2.getSchemaType()) != null && type2 instanceof XmlSchemaComplexType) {
                    XmlSchemaComplexType complexType2 = (XmlSchemaComplexType)type2;
                    XmlSchemaParticle particle2 = complexType2.getParticle();
                    if (particle2 != null && particle2 instanceof XmlSchemaSequence) {
                        XmlSchemaSequence xmlSchemaSequence2 = (XmlSchemaSequence)particle2;
                        XmlSchemaObjectCollection schemaObjectCollection2 = xmlSchemaSequence2.getItems();
                        if (schemaObjectCollection2 != null) {
                            Iterator iterator = schemaObjectCollection2.getIterator();
                            while (iterator.hasNext()) {
                                QName inMessageElementType;
                                Object next = iterator.next();
                                if (!(next instanceof XmlSchemaElement)) {
                                    isRPC = false;
                                }
                                XmlSchemaElement innerElement = (XmlSchemaElement)next;
                                QName schemaTypeName = innerElement.getSchemaTypeName();
                                String name = innerElement.getName();
                                if (innerElement.getRefName() != null) {
                                    isRPC = false;
                                }
                                if (outMessageElementDetails.get(name) != null) {
                                    isRPC = false;
                                }
                                if ((inMessageElementType = (QName)inMessageElementDetails.get(name)) != null && inMessageElementType != schemaTypeName) {
                                    isRPC = false;
                                }
                                outMessageElementDetails.put(name, schemaTypeName);
                            }
                        }
                    } else {
                        isRPC = false;
                    }
                } else {
                    isRPC = false;
                }
            } else {
                isRPC = false;
            }
        }
        int count = 0;
        if (isRPC) {
            styles.add(new URI("http://www.w3.org/ns/wsdl/style/rpc"));
            axisOperation.addParameter("wrpc:signature", this.generateRPCSignature(inMessageElementDetails, outMessageElementDetails));
            ++count;
        }
        if (isIRI) {
            styles.add(new URI("http://www.w3.org/ns/wsdl/style/iri"));
            ++count;
        }
        if (!isMultipart) return styles.toArray(new URI[count]);
        styles.add(new URI("http://www.w3.org/ns/wsdl/style/multipart"));
        ++count;
        return styles.toArray(new URI[count]);
    }

    private String generateRPCSignature(Map inMessageElementDetails, Map outMessageElementDetails) {
        String in = "";
        String out = "";
        String inOut = "";
        Set inElementSet = inMessageElementDetails.keySet();
        Set outElementSet = outMessageElementDetails.keySet();
        Iterator inElementIterator = inElementSet.iterator();
        while (inElementIterator.hasNext()) {
            String inElementName = (String)inElementIterator.next();
            if (outElementSet.contains(inElementName)) {
                inOut = inOut + inElementName + " " + "#inout" + " ";
                outElementSet.remove(inElementName);
                continue;
            }
            in = in + inElementName + " " + "#in" + " ";
        }
        Iterator outElementIterator = outElementSet.iterator();
        while (outElementIterator.hasNext()) {
            String outElementName = (String)outElementIterator.next();
            out = out + outElementName + " " + "#return" + " ";
        }
        return in + out + inOut;
    }
}

