/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.DeploymentClassLoader;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.repository.util.ArchiveReader;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.deployment.util.BeanExcludeInfo;
import org.apache.axis2.deployment.util.ExcludeInfo;
import org.apache.axis2.deployment.util.PhasesInfo;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisOperationFactory;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Flow;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.java2wsdl.DefaultSchemaGenerator;
import org.apache.axis2.description.java2wsdl.DocLitBareSchemaGenerator;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.util.Loader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.commons.schema.utils.NamespaceMap;
import org.codehaus.jam.JAnnotation;
import org.codehaus.jam.JMethod;

public class Utils {
    public static String defaultEncoding = new OutputStreamWriter(System.out).getEncoding();
    private static Log log = LogFactory.getLog((Class)Utils.class);

    public static void addFlowHandlers(Flow flow, ClassLoader clsLoader) throws AxisFault {
        int count = flow.getHandlerCount();
        for (int j = 0; j < count; ++j) {
            HandlerDescription handlermd = flow.getHandler(j);
            Class handlerClass = Utils.getHandlerClass(handlermd.getClassName(), clsLoader);
            try {
                Handler handler = (Handler)handlerClass.newInstance();
                handler.init(handlermd);
                handlermd.setHandler(handler);
                continue;
            }
            catch (InstantiationException e) {
                throw AxisFault.makeFault(e);
            }
            catch (IllegalAccessException e) {
                throw AxisFault.makeFault(e);
            }
        }
    }

    public static void loadHandler(ClassLoader loader1, HandlerDescription desc) throws DeploymentException {
        String handlername = desc.getClassName();
        try {
            Class handlerClass = Loader.loadClass(loader1, handlername);
            if (handlerClass.getPackage().getName().equals("org.apache.axis2.engine")) {
                String name = handlerClass.getName();
                log.warn((Object)("Dispatcher " + name + " is now deprecated."));
                if (name.indexOf("InstanceDispatcher") != -1) {
                    log.warn((Object)("Please remove the entry for " + handlerClass.getName() + "from axis2.xml"));
                } else {
                    log.warn((Object)"Please edit axis2.xml and replace with the same class in org.apache.axis2.dispatchers package");
                }
            }
            Handler handler = (Handler)handlerClass.newInstance();
            handler.init(desc);
            desc.setHandler(handler);
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentException(e);
        }
        catch (Exception e) {
            throw new DeploymentException(e);
        }
    }

    public static URL[] getURLsForAllJars(URL url, File tmpDir) {
        try {
            ZipEntry entry;
            ArrayList<URL> array = new ArrayList<URL>();
            InputStream in = url.openStream();
            String fileName = url.getFile();
            int index = fileName.lastIndexOf(47);
            if (index != -1) {
                fileName = fileName.substring(index + 1);
            }
            File f = Utils.createTempFile(fileName, in, tmpDir);
            in.close();
            FileInputStream fin = new FileInputStream(f);
            array.add(f.toURL());
            ZipInputStream zin = new ZipInputStream(fin);
            while ((entry = zin.getNextEntry()) != null) {
                String entryName = entry.getName();
                if (entryName == null || !entryName.toLowerCase().startsWith("lib/") || !entryName.toLowerCase().endsWith(".jar")) continue;
                String suffix = entryName.substring(4);
                f = Utils.createTempFile(suffix, zin, tmpDir);
                array.add(f.toURL());
            }
            zin.close();
            if (fin != null) {
                fin.close();
            }
            return array.toArray(new URL[array.size()]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static File createTempFile(String suffix, InputStream in, File tmpDir) throws IOException {
        int count;
        File f;
        byte[] data = new byte[2048];
        if (tmpDir == null) {
            new File(System.getProperty("java.io.tmpdir"), "_axis2").mkdirs();
            File tempFile = new File(System.getProperty("java.io.tmpdir"), "_axis2");
            f = File.createTempFile("axis2", suffix, tempFile);
        } else {
            f = File.createTempFile("axis2", suffix, tmpDir);
        }
        if (log.isDebugEnabled()) {
            log.info((Object)("Created temporary file : " + f.getAbsolutePath()));
        }
        f.deleteOnExit();
        FileOutputStream out = new FileOutputStream(f);
        while ((count = in.read(data, 0, 2048)) != -1) {
            out.write(data, 0, count);
        }
        out.close();
        return f;
    }

    public static ClassLoader getClassLoader(ClassLoader parent, String path) throws DeploymentException {
        return Utils.getClassLoader(parent, new File(path));
    }

    public static ClassLoader getClassLoader(ClassLoader parent, File file) throws DeploymentException {
        if (file == null) {
            return null;
        }
        try {
            File jarfile;
            int i;
            File[] jarfiles;
            ArrayList<URL> urls = new ArrayList<URL>();
            urls.add(file.toURL());
            File libfiles = new File(file, "lib");
            if (libfiles.exists()) {
                urls.add(libfiles.toURL());
                jarfiles = libfiles.listFiles();
                for (i = 0; i < jarfiles.length; ++i) {
                    jarfile = jarfiles[i];
                    if (!jarfile.getName().endsWith(".jar")) continue;
                    urls.add(jarfile.toURL());
                }
            } else {
                libfiles = new File(file, "Lib");
                if (libfiles.exists()) {
                    urls.add(libfiles.toURL());
                    jarfiles = libfiles.listFiles();
                    for (i = 0; i < jarfiles.length; ++i) {
                        jarfile = jarfiles[i];
                        if (!jarfile.getName().endsWith(".jar")) continue;
                        urls.add(jarfile.toURL());
                    }
                }
            }
            URL[] urllist = new URL[urls.size()];
            for (i = 0; i < urls.size(); ++i) {
                urllist[i] = (URL)urls.get(i);
            }
            URLClassLoader classLoader = new URLClassLoader(urllist, parent);
            return classLoader;
        }
        catch (MalformedURLException e) {
            throw new DeploymentException(e);
        }
    }

    private static Class getHandlerClass(String className, ClassLoader loader1) throws AxisFault {
        Class handlerClass;
        try {
            handlerClass = Loader.loadClass(loader1, className);
        }
        catch (ClassNotFoundException e) {
            throw AxisFault.makeFault(e);
        }
        return handlerClass;
    }

    public static void fillAxisService(AxisService axisService, AxisConfiguration axisConfig, ArrayList excludeOperations, ArrayList nonRpcMethods) throws Exception {
        String serviceClass;
        Parameter implInfoParam = axisService.getParameter("ServiceClass");
        ClassLoader serviceClassLoader = axisService.getClassLoader();
        if (implInfoParam != null) {
            serviceClass = (String)implInfoParam.getValue();
        } else {
            implInfoParam = axisService.getParameter("ServiceObjectSupplier");
            if (implInfoParam != null) {
                String className = ((String)implInfoParam.getValue()).trim();
                Class serviceObjectMaker = Loader.loadClass(serviceClassLoader, className);
                if (serviceObjectMaker.getModifiers() != 1) {
                    throw new AxisFault("Service class " + className + " must have public as access Modifier");
                }
                Method method = serviceObjectMaker.getMethod("getServiceObject", AxisService.class);
                Object obj = null;
                if (method != null) {
                    obj = method.invoke(serviceObjectMaker.newInstance(), axisService);
                }
                if (obj == null) {
                    log.warn((Object)"ServiceObjectSupplier implmentation Object could not be found");
                    throw new DeploymentException("ServiceClass or ServiceObjectSupplier implmentation Object could not be found");
                }
                serviceClass = obj.getClass().getName();
            } else {
                return;
            }
        }
        NamespaceMap map = new NamespaceMap();
        map.put((Object)"ns1", (Object)"http://org.apache.axis2/xsd");
        map.put((Object)"xs", (Object)"http://www.w3.org/2001/XMLSchema");
        axisService.setNameSpacesMap(map);
        Parameter generateBare = axisService.getParameter("doclitBare");
        DefaultSchemaGenerator schemaGenerator = generateBare != null && "true".equals(generateBare.getValue()) ? new DocLitBareSchemaGenerator(serviceClassLoader, serviceClass.trim(), axisService.getSchematargetNamespace(), axisService.getSchemaTargetNamespacePrefix(), axisService) : new DefaultSchemaGenerator(serviceClassLoader, serviceClass.trim(), axisService.getSchematargetNamespace(), axisService.getSchemaTargetNamespacePrefix(), axisService);
        schemaGenerator.setExcludeMethods(excludeOperations);
        schemaGenerator.setNonRpcMethods(nonRpcMethods);
        if (!axisService.isElementFormDefault()) {
            schemaGenerator.setElementFormDefault("unqualified");
        }
        schemaGenerator.setPkg2nsmap(axisService.getP2nMap());
        Collection schemas = schemaGenerator.generateSchema();
        axisService.addSchema(schemas);
        axisService.setSchemaTargetNamespace(schemaGenerator.getSchemaTargetNameSpace());
        axisService.setTypeTable(schemaGenerator.getTypeTable());
        if ("http://ws.apache.org/axis2".equals(axisService.getTargetNamespace())) {
            axisService.setTargetNamespace(schemaGenerator.getTargetNamespace());
        }
        JMethod[] method = schemaGenerator.getMethods();
        PhasesInfo pinfo = axisConfig.getPhasesInfo();
        for (int i = 0; i < method.length; ++i) {
            MessageReceiver mr;
            JMethod jmethod = method[i];
            String opName = Utils.getSimpleName(jmethod);
            AxisOperation operation = axisService.getOperation(new QName(opName));
            if (operation == null) {
                operation = axisService.getOperation(new QName(Utils.getSimpleName(jmethod)));
            }
            if ((mr = axisService.getMessageReceiver(operation.getMessageExchangePattern())) == null) {
                mr = axisConfig.getMessageReceiver(operation.getMessageExchangePattern());
            }
            if (operation.getMessageReceiver() == null) {
                operation.setMessageReceiver(mr);
            }
            pinfo.setOperationPhases(operation);
            axisService.addOperation(operation);
            if (operation.getSoapAction() != null) continue;
            operation.setSoapAction("urn:" + opName);
        }
    }

    public static AxisOperation getAxisOperationForJmethod(JMethod jmethod) throws AxisFault {
        String action;
        AxisOperation operation = jmethod.getReturnType().isVoidType() ? (jmethod.getExceptionTypes().length > 0 ? AxisOperationFactory.getAxisOperation(11) : AxisOperationFactory.getAxisOperation(10)) : AxisOperationFactory.getAxisOperation(12);
        String opName = Utils.getSimpleName(jmethod);
        operation.setName(new QName(opName));
        JAnnotation methodAnnon = jmethod.getAnnotation("javax.jws.WebMethod");
        if (methodAnnon != null && (action = methodAnnon.getValue("action").asString()) != null && !"".equals(action)) {
            operation.setSoapAction(action);
        }
        return operation;
    }

    public static String getSimpleName(JMethod method) {
        JAnnotation methodAnnon = method.getAnnotation("javax.jws.WebMethod");
        if (methodAnnon != null && methodAnnon.getValue("operationName") != null) {
            return methodAnnon.getValue("operationName").asString();
        }
        return method.getSimpleName();
    }

    public static OMElement getParameter(String name, String value, boolean locked) {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMElement parameter = fac.createOMElement("parameter", null);
        parameter.addAttribute("name", name, null);
        parameter.addAttribute("locked", Boolean.toString(locked), null);
        parameter.setText(value);
        return parameter;
    }

    public static void deployModuleServices(AxisModule module, ConfigurationContext configCtx) throws AxisFault {
        try {
            AxisConfiguration axisConfig = configCtx.getAxisConfiguration();
            ArchiveReader archiveReader = new ArchiveReader();
            PhasesInfo phasesInfo = axisConfig.getPhasesInfo();
            ClassLoader moduleClassLoader = module.getModuleClassLoader();
            ArrayList<String> services = new ArrayList<String>();
            InputStream in = moduleClassLoader.getResourceAsStream("aars/aars.list");
            if (in != null) {
                try {
                    String line;
                    BufferedReader input = new BufferedReader(new InputStreamReader(in));
                    while ((line = input.readLine()) != null) {
                        if ((line = line.trim()).length() <= 0 || line.charAt(0) == '#') continue;
                        services.add(line);
                    }
                    input.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            if (services.size() > 0) {
                for (int i = 0; i < services.size(); ++i) {
                    String servicename = (String)services.get(i);
                    if (servicename == null || "".equals(servicename)) continue;
                    InputStream fin = moduleClassLoader.getResourceAsStream("aars/" + servicename);
                    if (fin == null) {
                        throw new AxisFault("No service archive found : " + servicename);
                    }
                    File inputFile = Utils.createTempFile(servicename, fin, (File)axisConfig.getParameterValue("artifactsDIR"));
                    DeploymentFileData filedata = new DeploymentFileData(inputFile);
                    filedata.setClassLoader(false, moduleClassLoader, (File)axisConfig.getParameterValue("artifactsDIR"));
                    HashMap wsdlservice = archiveReader.processWSDLs(filedata);
                    if (wsdlservice != null && wsdlservice.size() > 0) {
                        Iterator servicesitr = wsdlservice.values().iterator();
                        while (servicesitr.hasNext()) {
                            AxisService service = (AxisService)servicesitr.next();
                            Iterator operations = service.getOperations();
                            while (operations.hasNext()) {
                                AxisOperation axisOperation = (AxisOperation)operations.next();
                                phasesInfo.setOperationPhases(axisOperation);
                            }
                        }
                    }
                    AxisServiceGroup serviceGroup = new AxisServiceGroup(axisConfig);
                    serviceGroup.setServiceGroupClassLoader(filedata.getClassLoader());
                    ArrayList serviceList = archiveReader.processServiceGroup(filedata.getAbsolutePath(), filedata, serviceGroup, false, wsdlservice, configCtx);
                    for (int j = 0; j < serviceList.size(); ++j) {
                        AxisService axisService = (AxisService)serviceList.get(j);
                        Parameter moduleService = new Parameter();
                        moduleService.setValue("true");
                        moduleService.setName("moduleService");
                        axisService.addParameter(moduleService);
                        serviceGroup.addService(axisService);
                    }
                    axisConfig.addServiceGroup(serviceGroup);
                    fin.close();
                }
            }
        }
        catch (IOException e) {
            throw AxisFault.makeFault(e);
        }
    }

    public static String normalize(String uri) {
        if ("".equals(uri)) {
            return uri;
        }
        int leadingSlashes = 0;
        for (leadingSlashes = 0; leadingSlashes < uri.length() && uri.charAt(leadingSlashes) == '/'; ++leadingSlashes) {
        }
        boolean isDir = uri.charAt(uri.length() - 1) == '/';
        StringTokenizer st = new StringTokenizer(uri, "/");
        LinkedList<String> clean = new LinkedList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if ("..".equals(token)) {
                if (!clean.isEmpty() && !"..".equals(clean.getLast())) {
                    clean.removeLast();
                    if (st.hasMoreTokens()) continue;
                    isDir = true;
                    continue;
                }
                clean.add("..");
                continue;
            }
            if (".".equals(token) || "".equals(token)) continue;
            clean.add(token);
        }
        StringBuffer sb = new StringBuffer();
        while (leadingSlashes-- > 0) {
            sb.append('/');
        }
        Iterator it = clean.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append('/');
        }
        if (isDir && sb.length() > 0 && sb.charAt(sb.length() - 1) != '/') {
            sb.append('/');
        }
        return sb.toString();
    }

    public static String getPath(String parent, String childPath) {
        String value;
        int i;
        String[] values;
        Stack<String> parentStack = new Stack<String>();
        Stack<String> childStack = new Stack<String>();
        if (parent != null && (values = parent.split("/")).length > 0) {
            for (i = 0; i < values.length; ++i) {
                value = values[i];
                parentStack.push(value);
            }
        }
        if ((values = childPath.split("/")).length > 0) {
            for (i = 0; i < values.length; ++i) {
                value = values[i];
                childStack.push(value);
            }
        }
        String filepath = "";
        while (!childStack.isEmpty()) {
            value = (String)childStack.pop();
            if ("..".equals(value)) {
                parentStack.pop();
                continue;
            }
            if ("".equals(value)) continue;
            if ("".equals(filepath)) {
                filepath = value;
                continue;
            }
            filepath = value + "/" + filepath;
        }
        while (!parentStack.isEmpty()) {
            value = (String)parentStack.pop();
            if ("".equals(value)) continue;
            filepath = value + "/" + filepath;
        }
        return filepath;
    }

    public static List findLibJars(URL url) {
        ArrayList<String> embedded_jars = new ArrayList<String>();
        try {
            ZipEntry entry;
            ZipInputStream zin = new ZipInputStream(url.openStream());
            String entryName = "";
            while ((entry = zin.getNextEntry()) != null) {
                entryName = entry.getName();
                if (entryName == null || !entryName.startsWith("lib/") && !entryName.startsWith("Lib/") || !entryName.endsWith(".jar")) continue;
                embedded_jars.add(entryName);
            }
            zin.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return embedded_jars;
    }

    public static void addExcludeMethods(ArrayList excludeList) {
        excludeList.add("init");
        excludeList.add("setOperationContext");
        excludeList.add("startUp");
        excludeList.add("destroy");
        excludeList.add("shutDown");
    }

    public static ClassLoader createClassLoader(URL[] urls, ClassLoader serviceClassLoader, boolean extractJars, File tmpDir) {
        if (extractJars) {
            try {
                URL[] urls1 = Utils.getURLsForAllJars(urls[0], tmpDir);
                return new DeploymentClassLoader(urls1, null, serviceClassLoader);
            }
            catch (Exception e) {
                log.warn((Object)("Exception extracting jars into temporary directory : " + e.getMessage() + " : switching to alternate class loading mechanism"));
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
        List embedded_jars = Utils.findLibJars(urls[0]);
        return new DeploymentClassLoader(urls, embedded_jars, serviceClassLoader);
    }

    public static File toFile(URL url) throws UnsupportedEncodingException {
        String path = URLDecoder.decode(url.getPath(), defaultEncoding);
        File file = new File(path.replace('/', File.separatorChar).replace('|', ':'));
        return file;
    }

    public static void processBeanPropertyExclude(AxisService service) {
        Parameter excludeBeanProperty = service.getParameter("beanPropertyRules");
        if (excludeBeanProperty != null) {
            OMElement parameterElement = excludeBeanProperty.getParameterElement();
            Iterator bneasItr = parameterElement.getChildrenWithName(new QName("bean"));
            ExcludeInfo excludeInfo = new ExcludeInfo();
            while (bneasItr.hasNext()) {
                OMElement bean = (OMElement)bneasItr.next();
                String clazz = bean.getAttributeValue(new QName("class"));
                String excludePropertees = bean.getAttributeValue(new QName("excludeProperties"));
                String includeProperties = bean.getAttributeValue(new QName("includeProperties"));
                excludeInfo.putBeanInfo(clazz, new BeanExcludeInfo(excludePropertees, includeProperties));
            }
            service.setExcludeInfo(excludeInfo);
        }
    }

    private static List getArrayFromString(String value) {
        String[] values = value.split(",");
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < values.length; ++i) {
            String s = values[i];
            list.add(s);
        }
        return list;
    }

    public static String getShortFileName(String filename) {
        File file = new File(filename);
        return file.getName();
    }
}

