/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.context.externalize;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamConstants;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.axis2.context.externalize.DebugObjectOutputStream;
import org.apache.axis2.context.externalize.ExternalizeConstants;
import org.apache.axis2.context.externalize.SafeSerializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SafeObjectOutputStream
implements ObjectOutput,
ObjectStreamConstants,
ExternalizeConstants {
    private static final Log log = LogFactory.getLog((Class)SafeObjectOutputStream.class);
    private static final boolean isDebug = log.isDebugEnabled();
    private ObjectOutput out = null;
    private static final boolean FORM_BYTE = false;
    private static final boolean FORM_OBJECT = true;
    MyOOS tempOOS = null;
    public static Hashtable notSerializableList = new Hashtable();

    public static SafeObjectOutputStream install(ObjectOutput out) throws IOException {
        if (out instanceof SafeObjectOutputStream) {
            return (SafeObjectOutputStream)out;
        }
        return new SafeObjectOutputStream(out);
    }

    private SafeObjectOutputStream(ObjectOutput oo) throws IOException {
        this.out = log.isDebugEnabled() ? new DebugObjectOutputStream(oo) : oo;
    }

    public void close() throws IOException {
        if (this.tempOOS != null) {
            this.tempOOS.close();
            this.tempOOS = null;
        }
        this.out.close();
    }

    public void defaultWriteObject() throws IOException {
        if (this.out instanceof ObjectOutputStream) {
            ((ObjectOutputStream)this.out).defaultWriteObject();
        }
    }

    public boolean equals(Object o) {
        return this.out.equals(o);
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public int hashCode() {
        return this.out.hashCode();
    }

    public ObjectOutputStream.PutField putFields() throws IOException {
        if (this.out instanceof ObjectOutputStream) {
            return ((ObjectOutputStream)this.out).putFields();
        }
        throw new IOException("This method is not supported.");
    }

    public void reset() throws IOException {
        if (this.out instanceof ObjectOutputStream) {
            ((ObjectOutputStream)this.out).reset();
        }
    }

    public String toString() {
        return this.out.toString();
    }

    public void useProtocolVersion(int version) throws IOException {
        if (this.out instanceof ObjectOutputStream) {
            ((ObjectOutputStream)this.out).useProtocolVersion(version);
        }
    }

    public void write(byte[] buf, int off, int len) throws IOException {
        this.out.write(buf, off, len);
    }

    public void write(byte[] buf) throws IOException {
        this.out.write(buf);
    }

    public void write(int val) throws IOException {
        this.out.write(val);
    }

    public void writeBoolean(boolean val) throws IOException {
        this.out.writeBoolean(val);
    }

    public void writeByte(int val) throws IOException {
        this.out.writeByte(val);
    }

    public void writeBytes(String str) throws IOException {
        this.out.writeBytes(str);
    }

    public void writeChar(int val) throws IOException {
        this.out.writeChar(val);
    }

    public void writeChars(String str) throws IOException {
        this.out.writeChars(str);
    }

    public void writeDouble(double val) throws IOException {
        this.out.writeDouble(val);
    }

    public void writeFields() throws IOException {
        if (this.out instanceof ObjectOutputStream) {
            ((ObjectOutputStream)this.out).writeFields();
        }
    }

    public void writeFloat(float val) throws IOException {
        this.out.writeFloat(val);
    }

    public void writeInt(int val) throws IOException {
        this.out.writeInt(val);
    }

    public void writeLong(long val) throws IOException {
        this.out.writeLong(val);
    }

    public void writeObject(Object obj) throws IOException {
        this.writeObject(obj, false);
    }

    public void writeShort(int val) throws IOException {
        this.out.writeShort(val);
    }

    public void writeUTF(String str) throws IOException {
        this.out.writeUTF(str);
    }

    public boolean writeMap(Map map) throws IOException {
        if (map == null) {
            this.out.writeBoolean(false);
            return false;
        }
        this.out.writeBoolean(true);
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            Object value = map.get(key);
            this.writePair(key, false, value, false);
        }
        this.out.writeBoolean(false);
        return true;
    }

    public boolean writeList(List al) throws IOException {
        if (al == null) {
            this.out.writeBoolean(false);
            return false;
        }
        this.out.writeBoolean(true);
        Iterator it = al.iterator();
        while (it.hasNext()) {
            Object value = it.next();
            this.writeItem(value, false);
        }
        this.out.writeBoolean(false);
        return true;
    }

    private boolean writeObject(Object obj, boolean isSafe) throws IOException {
        if (isDebug) {
            log.debug((Object)("Writing object:" + this.valueName(obj)));
        }
        if (obj == null) {
            this.out.writeBoolean(false);
            return false;
        }
        if (!isSafe && !SafeObjectOutputStream.isSerializable(obj)) {
            this.out.writeBoolean(false);
            return false;
        }
        if (!isSafe) {
            isSafe = SafeObjectOutputStream.isSafeSerializable(obj);
        }
        if (isSafe) {
            if (isDebug) {
                log.debug((Object)"  write using object form");
            }
            this.out.writeBoolean(true);
            this.out.writeBoolean(true);
            this.out.writeObject(obj);
        } else {
            MyOOS tempOOS;
            if (isDebug) {
                log.debug((Object)"  write using byte form");
            }
            try {
                tempOOS = this.writeTempOOS(obj);
            }
            catch (IOException e) {
                this.out.writeBoolean(false);
                throw e;
            }
            if (tempOOS == null) {
                this.out.writeBoolean(false);
                return false;
            }
            this.out.writeBoolean(true);
            this.out.writeBoolean(false);
            tempOOS.write(this.out);
            this.resetOnSuccess();
        }
        return true;
    }

    public boolean writePair(Object obj1, boolean isSafe1, Object obj2, boolean isSafe2) throws IOException {
        boolean isSafe;
        if (isDebug) {
            log.debug((Object)("Writing key=" + this.valueName(obj1) + " value=" + this.valueName(obj2)));
        }
        if (!isSafe1 && !SafeObjectOutputStream.isSerializable(obj1) || !isSafe2 && !SafeObjectOutputStream.isSerializable(obj2)) {
            return false;
        }
        boolean bl = isSafe = !(!isSafe1 && !SafeObjectOutputStream.isSafeSerializable(obj1) || !isSafe2 && !SafeObjectOutputStream.isSafeSerializable(obj2));
        if (isSafe) {
            if (isDebug) {
                log.debug((Object)"  write using object form");
            }
            this.out.writeBoolean(true);
            this.out.writeBoolean(true);
            this.out.writeObject(obj1);
            this.out.writeObject(obj2);
        } else {
            MyOOS tempOOS;
            if (isDebug) {
                log.debug((Object)"  write using byte form");
            }
            if ((tempOOS = this.writeTempOOS(obj1, obj2)) == null) {
                return false;
            }
            this.out.writeBoolean(true);
            this.out.writeBoolean(false);
            tempOOS.write(this.out);
            this.resetOnSuccess();
        }
        return true;
    }

    public boolean writeItem(Object obj, boolean isSafe) throws IOException {
        if (isDebug) {
            log.debug((Object)("Writing obj=" + this.valueName(obj)));
        }
        if (!isSafe && !SafeObjectOutputStream.isSerializable(obj)) {
            return false;
        }
        boolean bl = isSafe = isSafe || SafeObjectOutputStream.isSafeSerializable(obj);
        if (isSafe) {
            if (isDebug) {
                log.debug((Object)"  write using object form");
            }
            this.out.writeBoolean(true);
            this.out.writeBoolean(true);
            this.out.writeObject(obj);
        } else {
            MyOOS tempOOS;
            if (isDebug) {
                log.debug((Object)"  write using byte form");
            }
            try {
                tempOOS = this.writeTempOOS(obj);
            }
            catch (RuntimeException e) {
                return false;
            }
            if (tempOOS == null) {
                return false;
            }
            this.out.writeBoolean(true);
            this.out.writeBoolean(false);
            tempOOS.write(this.out);
            this.resetOnSuccess();
        }
        return true;
    }

    private static boolean isSerializable(Object obj) {
        boolean isSerializable;
        boolean bl = isSerializable = obj == null || obj instanceof Serializable;
        if (!isSerializable) {
            SafeObjectOutputStream.markNotSerializable(obj);
        }
        return isSerializable;
    }

    private static boolean isSafeSerializable(Object obj) {
        boolean isSafeSerializable = obj == null || obj instanceof SafeSerializable || obj instanceof String || obj instanceof Integer || obj instanceof Boolean || obj instanceof Long;
        return isSafeSerializable;
    }

    private MyOOS writeTempOOS(Object obj) throws IOException {
        MyOOS oos = null;
        try {
            oos = this.getTempOOS();
            oos.writeObject(obj);
            oos.flush();
        }
        catch (NotSerializableException nse2) {
            SafeObjectOutputStream.markNotSerializable(obj);
            if (oos != null) {
                this.resetOnFailure();
                oos = null;
            }
            throw nse2;
        }
        catch (IOException e) {
            if (oos != null) {
                this.resetOnFailure();
                oos = null;
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (oos != null) {
                this.resetOnFailure();
                oos = null;
            }
            throw e;
        }
        return oos;
    }

    private MyOOS writeTempOOS(Object obj1, Object obj2) throws IOException {
        MyOOS oos = null;
        boolean first = true;
        try {
            oos = this.getTempOOS();
            oos.writeObject(obj1);
            first = false;
            oos.writeObject(obj2);
            oos.flush();
        }
        catch (NotSerializableException nse2) {
            SafeObjectOutputStream.markNotSerializable(first ? obj1 : obj2);
            if (oos != null) {
                this.resetOnFailure();
                oos = null;
            }
        }
        catch (IOException e) {
            if (oos != null) {
                this.resetOnFailure();
                oos = null;
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (oos != null) {
                this.resetOnFailure();
                oos = null;
            }
            throw e;
        }
        return oos;
    }

    private MyOOS getTempOOS() throws IOException {
        if (this.tempOOS == null) {
            this.tempOOS = new MyOOS(new MyBAOS());
        }
        return this.tempOOS;
    }

    private void resetOnFailure() throws IOException {
        if (this.tempOOS != null) {
            this.tempOOS.close();
            this.tempOOS = null;
        }
    }

    private void resetOnSuccess() throws IOException {
        this.tempOOS.reset();
    }

    private static void markNotSerializable(Object obj) {
        String name;
        Object value;
        if (!isDebug) {
            return;
        }
        if (obj != null && (value = notSerializableList.get(name = obj.getClass().getName())) == null) {
            notSerializableList.put(name, name);
            if (log.isTraceEnabled()) {
                log.trace((Object)("***NotSerializableException*** [" + name + "]"));
            }
        }
    }

    private String valueName(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        return "Object of class = " + obj.getClass().getName();
    }

    class MyOOS
    extends ObjectOutputStream {
        MyBAOS baos;
        int dataOffset;

        MyOOS(MyBAOS baos) throws IOException {
            super(baos);
            this.flush();
            this.baos = baos;
            this.dataOffset = baos.size();
        }

        public void reset() throws IOException {
            super.reset();
            this.baos.reset(this.dataOffset);
        }

        public void write(ObjectOutput out) throws IOException {
            out.flush();
            out.writeInt(this.baos.size());
            out.write(this.baos.getBytes(), 0, this.baos.size());
        }
    }

    class MyBAOS
    extends ByteArrayOutputStream {
        MyBAOS() {
        }

        public byte[] getBytes() {
            return this.buf;
        }

        public void reset(int count) {
            this.count = count;
        }
    }
}

