/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.context.externalize;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectStreamConstants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.externalize.DebugObjectInput;
import org.apache.axis2.context.externalize.ObjectInputStreamWithCL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SafeObjectInputStream
implements ObjectInput,
ObjectStreamConstants {
    private static final Log log = LogFactory.getLog((Class)SafeObjectInputStream.class);
    private static final boolean isDebug = log.isDebugEnabled();
    ObjectInput in = null;
    final ObjectInput original;
    private byte[] buffer = null;
    private final int BUFFER_MIN_SIZE = 4096;

    public static SafeObjectInputStream install(ObjectInput in) {
        if (in instanceof SafeObjectInputStream) {
            return (SafeObjectInputStream)in;
        }
        return new SafeObjectInputStream(in);
    }

    private SafeObjectInputStream(ObjectInput in) {
        this.original = in;
        this.in = log.isDebugEnabled() ? new DebugObjectInput(this.original) : this.original;
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public void close() throws IOException {
        this.in.close();
    }

    public int read() throws IOException {
        return this.in.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.in.read(b, off, len);
    }

    public int read(byte[] b) throws IOException {
        return this.in.read(b);
    }

    public boolean readBoolean() throws IOException {
        return this.in.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.in.readByte();
    }

    public char readChar() throws IOException {
        return this.in.readChar();
    }

    public double readDouble() throws IOException {
        return this.in.readDouble();
    }

    public float readFloat() throws IOException {
        return this.in.readFloat();
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        this.in.readFully(b, off, len);
    }

    public void readFully(byte[] b) throws IOException {
        this.in.readFully(b);
    }

    public int readInt() throws IOException {
        return this.in.readInt();
    }

    public String readLine() throws IOException {
        return this.in.readLine();
    }

    public long readLong() throws IOException {
        return this.in.readLong();
    }

    public Object readObject() throws ClassNotFoundException, IOException {
        return this.readObjectOverride();
    }

    public short readShort() throws IOException {
        return this.in.readShort();
    }

    public int readUnsignedByte() throws IOException {
        return this.in.readUnsignedByte();
    }

    public int readUnsignedShort() throws IOException {
        return this.in.readUnsignedShort();
    }

    public String readUTF() throws IOException {
        return this.in.readUTF();
    }

    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    public int skipBytes(int n) throws IOException {
        return this.in.skipBytes(n);
    }

    public HashMap readHashMap() throws IOException {
        HashMap hashMap = new HashMap();
        return (HashMap)this.readMap(hashMap);
    }

    public Map readMap(Map map) throws IOException {
        boolean isActive = this.in.readBoolean();
        if (!isActive) {
            return null;
        }
        while (this.in.readBoolean()) {
            Object key = null;
            Object value = null;
            boolean isObjectForm = this.in.readBoolean();
            try {
                if (isObjectForm) {
                    if (isDebug) {
                        log.debug((Object)" reading using object form");
                    }
                    key = this.in.readObject();
                    value = this.in.readObject();
                } else {
                    if (isDebug) {
                        log.debug((Object)" reading using byte form");
                    }
                    ByteArrayInputStream bais = this.getByteStream(this.in);
                    ObjectInputStream tempOIS = this.createObjectInputStream(bais);
                    key = tempOIS.readObject();
                    value = tempOIS.readObject();
                    tempOIS.close();
                    bais.close();
                }
                if (isDebug) {
                    log.debug((Object)("Read key=" + this.valueName(key) + " value=" + this.valueName(value)));
                }
                map.put(key, value);
            }
            catch (ClassNotFoundException e) {
                log.error((Object)e);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw AxisFault.makeFault(e);
            }
        }
        return map;
    }

    public ArrayList readArrayList() throws IOException {
        ArrayList ll = new ArrayList();
        return (ArrayList)this.readList(ll);
    }

    public LinkedList readLinkedList() throws IOException {
        LinkedList ll = new LinkedList();
        return (LinkedList)this.readList(ll);
    }

    public List readList(List list) throws IOException {
        boolean isActive = this.in.readBoolean();
        if (!isActive) {
            return null;
        }
        while (this.in.readBoolean()) {
            boolean isObjectForm = this.in.readBoolean();
            try {
                Object value;
                if (isObjectForm) {
                    if (isDebug) {
                        log.debug((Object)" reading using object form");
                    }
                    value = this.in.readObject();
                } else {
                    if (isDebug) {
                        log.debug((Object)" reading using byte form");
                    }
                    ByteArrayInputStream bais = this.getByteStream(this.in);
                    ObjectInputStream tempOIS = this.createObjectInputStream(bais);
                    value = tempOIS.readObject();
                    tempOIS.close();
                    bais.close();
                }
                if (isDebug) {
                    log.debug((Object)("Read value=" + this.valueName(value)));
                }
                list.add(value);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw AxisFault.makeFault(e);
            }
        }
        return list;
    }

    private Object readObjectOverride() throws IOException, ClassNotFoundException {
        boolean isActive = this.in.readBoolean();
        if (!isActive) {
            if (isDebug) {
                log.debug((Object)"Read object=null");
            }
            return null;
        }
        Object obj = null;
        boolean isObjectForm = this.in.readBoolean();
        if (isObjectForm) {
            if (isDebug) {
                log.debug((Object)" reading using object form");
            }
            obj = this.in.readObject();
        } else {
            if (isDebug) {
                log.debug((Object)" reading using byte form");
            }
            ByteArrayInputStream bais = this.getByteStream(this.in);
            ObjectInputStream tempOIS = this.createObjectInputStream(bais);
            obj = tempOIS.readObject();
            tempOIS.close();
            bais.close();
        }
        if (isDebug) {
            log.debug((Object)("Read object=" + this.valueName(obj)));
        }
        return obj;
    }

    private String valueName(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        return "Object of class = " + obj.getClass().getName();
    }

    private ByteArrayInputStream getByteStream(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        if (this.buffer == null || this.buffer.length < size) {
            int allocSize = size > 4096 ? size : 4096;
            this.buffer = new byte[allocSize];
        }
        in.readFully(this.buffer, 0, size);
        return new ByteArrayInputStream(this.buffer, 0, size);
    }

    private ObjectInputStream createObjectInputStream(InputStream is) throws IOException {
        return new ObjectInputStreamWithCL(is);
    }
}

