/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.context;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.AbstractContext;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.context.externalize.SafeObjectInputStream;
import org.apache.axis2.context.externalize.SafeObjectOutputStream;
import org.apache.axis2.context.externalize.SafeSerializable;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.DependencyManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SessionContext
extends AbstractContext
implements Externalizable,
SafeSerializable {
    private static final long serialVersionUID = -1100610673067568556L;
    private static final int REVISION_2 = 2;
    private static final int revisionID = 2;
    private transient HashMap serviceContextMap = new HashMap();
    private transient HashMap serviceGroupContextMap = new HashMap();
    private String cookieID;
    private static final Log log = LogFactory.getLog((Class)SessionContext.class);
    private static final String myClassName = "SessionContext";
    public long sessionContextTimeoutInterval = 30000L;

    public SessionContext(AbstractContext parent) {
        super(parent);
    }

    public SessionContext() {
    }

    public void init(AxisConfiguration axisConfiguration) throws AxisFault {
    }

    public ServiceContext getServiceContext(AxisService axisService) {
        return (ServiceContext)this.serviceContextMap.get(axisService.getName());
    }

    public void addServiceContext(ServiceContext serviceContext) {
        this.serviceContextMap.put(serviceContext.getAxisService().getName(), serviceContext);
    }

    public void addServiceGroupContext(ServiceGroupContext serviceGroupContext) {
        String serviceGroupID = serviceGroupContext.getDescription().getServiceGroupName();
        this.serviceGroupContextMap.put(serviceGroupID, serviceGroupContext);
    }

    public ServiceGroupContext getServiceGroupContext(String serviceGroupID) {
        return (ServiceGroupContext)this.serviceGroupContextMap.get(serviceGroupID);
    }

    public String getCookieID() {
        return this.cookieID;
    }

    public void setCookieID(String cookieID) {
        this.cookieID = cookieID;
    }

    public void touch() {
        this.lastTouchedTime = new Date().getTime();
        if (this.parent != null) {
            this.parent.touch();
        }
    }

    public long getLastTouchedTime() {
        return this.lastTouchedTime;
    }

    public Iterator getServiceGroupContext() {
        if (this.serviceGroupContextMap != null) {
            if (this.serviceGroupContextMap.isEmpty()) {
                return null;
            }
            return this.serviceGroupContextMap.values().iterator();
        }
        return null;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.serviceGroupContextMap != null && !this.serviceGroupContextMap.isEmpty()) {
            Iterator valuse = this.serviceGroupContextMap.values().iterator();
            while (valuse.hasNext()) {
                ServiceGroupContext serviceGroupContext = (ServiceGroupContext)valuse.next();
                this.cleanupServiceContextes(serviceGroupContext);
            }
        }
    }

    private void cleanupServiceContextes(ServiceGroupContext serviceGroupContext) {
        Iterator serviceContecxtes = serviceGroupContext.getServiceContexts();
        while (serviceContecxtes.hasNext()) {
            ServiceContext serviceContext = (ServiceContext)serviceContecxtes.next();
            DependencyManager.destroyServiceObject(serviceContext);
        }
    }

    public void writeExternal(ObjectOutput o) throws IOException {
        SafeObjectOutputStream out = SafeObjectOutputStream.install(o);
        out.writeLong(-1100610673067568556L);
        out.writeInt(2);
        out.writeLong(this.getLastTouchedTime());
        out.writeLong(this.sessionContextTimeoutInterval);
        out.writeObject(this.cookieID);
        out.writeMap(this.getProperties());
        out.writeObject(this.parent);
    }

    public void readExternal(ObjectInput inObject) throws IOException, ClassNotFoundException {
        SafeObjectInputStream in = SafeObjectInputStream.install(inObject);
        if (log.isTraceEnabled()) {
            log.trace((Object)("SessionContext:readExternal():  BEGIN  bytes available in stream [" + in.available() + "]  "));
        }
        long suid = in.readLong();
        int revID = in.readInt();
        if (suid != -1100610673067568556L) {
            throw new ClassNotFoundException("Serialization version ID is not supported.");
        }
        if (revID != 2) {
            throw new ClassNotFoundException("Revision ID is not supported.");
        }
        long time = in.readLong();
        this.setLastTouchedTime(time);
        this.sessionContextTimeoutInterval = in.readLong();
        this.cookieID = (String)in.readObject();
        this.properties = in.readHashMap();
        this.parent = (AbstractContext)in.readObject();
    }

    public ConfigurationContext getRootContext() {
        return null;
    }
}

