/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.context;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.clustering.ClusterManager;
import org.apache.axis2.clustering.context.Replicator;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.PropertyDifference;

public abstract class AbstractContext {
    public static final String COPY_PROPERTIES = "CopyProperties";
    protected long lastTouchedTime;
    protected transient AbstractContext parent;
    protected transient Map properties;
    private transient Map propertyDifferences;

    protected AbstractContext(AbstractContext parent) {
        this.parent = parent;
    }

    protected AbstractContext() {
    }

    public AbstractContext getParent() {
        return this.parent;
    }

    public boolean isAncestor(AbstractContext context) {
        if (context == null) {
            return false;
        }
        for (AbstractContext ancestor = this.getParent(); ancestor != null; ancestor = ancestor.getParent()) {
            if (ancestor != context) continue;
            return true;
        }
        return false;
    }

    public Map getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        return this.properties;
    }

    public Iterator getPropertyNames() {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        return this.properties.keySet().iterator();
    }

    public Object getProperty(String key) {
        Object obj;
        Object object = obj = this.properties == null ? null : (Object)this.properties.get(key);
        if (obj == null && this.parent != null) {
            obj = this.parent.getProperty(key);
        } else {
            this.addPropertyDifference(key, obj, false);
        }
        return obj;
    }

    public Object getLocalProperty(String key) {
        Object obj;
        Object v0 = obj = this.properties == null ? null : this.properties.get(key);
        if (obj != null || this.parent == null) {
            this.addPropertyDifference(key, obj, false);
        }
        return obj;
    }

    public Object getPropertyNonReplicable(String key) {
        Object obj;
        Object object = obj = this.properties == null ? null : (Object)this.properties.get(key);
        if (obj == null && this.parent != null) {
            obj = this.parent.getPropertyNonReplicable(key);
        }
        return obj;
    }

    public void setProperty(String key, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(key, value);
        this.addPropertyDifference(key, value, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPropertyDifference(String key, Object value, boolean isRemoved) {
        if (!this.needPropertyDifferences()) {
            return;
        }
        AbstractContext abstractContext = this;
        synchronized (abstractContext) {
            if (this.propertyDifferences == null) {
                this.propertyDifferences = new HashMap();
            }
            this.propertyDifferences.put(key, new PropertyDifference(key, value, isRemoved));
        }
    }

    private boolean needPropertyDifferences() {
        ConfigurationContext cc = this.getRootContext();
        if (cc == null) {
            return false;
        }
        ClusterManager clusterManager = cc.getAxisConfiguration().getClusterManager();
        return clusterManager != null && clusterManager.getContextManager() != null;
    }

    public void setNonReplicableProperty(String key, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(key, value);
    }

    public synchronized void removeProperty(String key) {
        Object value = this.properties.get(key);
        if (value != null) {
            if (this.properties != null) {
                this.properties.remove(key);
            }
            this.addPropertyDifference(key, value, true);
        }
    }

    public synchronized void removePropertyNonReplicable(String key) {
        if (this.properties != null) {
            this.properties.remove(key);
        }
    }

    public synchronized Map getPropertyDifferences() {
        if (this.propertyDifferences == null) {
            this.propertyDifferences = new HashMap();
        }
        return this.propertyDifferences;
    }

    public synchronized void clearPropertyDifferences() {
        if (this.propertyDifferences != null) {
            this.propertyDifferences.clear();
        }
    }

    public void setParent(AbstractContext context) {
        this.parent = context;
    }

    public void setProperties(Map properties) {
        if (properties == null) {
            this.properties = null;
        } else {
            Boolean copyProperties = (Boolean)properties.get(COPY_PROPERTIES);
            if (copyProperties != null && copyProperties.booleanValue()) {
                this.mergeProperties(properties);
            } else {
                this.properties = properties;
            }
        }
    }

    public void mergeProperties(Map props) {
        if (props != null) {
            if (this.properties == null) {
                this.properties = new HashMap();
            }
            Iterator iterator = props.keySet().iterator();
            while (iterator.hasNext()) {
                Object key = iterator.next();
                this.properties.put(key, props.get(key));
            }
        }
    }

    protected void touch() {
        this.lastTouchedTime = System.currentTimeMillis();
        if (this.parent != null) {
            this.parent.touch();
        }
    }

    public long getLastTouchedTime() {
        return this.lastTouchedTime;
    }

    public void setLastTouchedTime(long t) {
        this.lastTouchedTime = t;
    }

    public void flush() throws AxisFault {
        Replicator.replicate(this);
    }

    public abstract ConfigurationContext getRootContext();
}

