/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.clustering.tribes;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.clustering.ClusterManager;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.RequestBlockingHandler;
import org.apache.axis2.clustering.configuration.ConfigurationManager;
import org.apache.axis2.clustering.configuration.DefaultConfigurationManager;
import org.apache.axis2.clustering.context.ClusteringContextListener;
import org.apache.axis2.clustering.context.ContextManager;
import org.apache.axis2.clustering.context.DefaultContextManager;
import org.apache.axis2.clustering.control.ControlCommand;
import org.apache.axis2.clustering.control.GetConfigurationCommand;
import org.apache.axis2.clustering.control.GetStateCommand;
import org.apache.axis2.clustering.tribes.AtMostOnceInterceptor;
import org.apache.axis2.clustering.tribes.ChannelListener;
import org.apache.axis2.clustering.tribes.ChannelSender;
import org.apache.axis2.clustering.tribes.ControlCommandProcessor;
import org.apache.axis2.clustering.tribes.InitializationRequestHandler;
import org.apache.axis2.clustering.tribes.MembershipManager;
import org.apache.axis2.clustering.tribes.TribesMembershipListener;
import org.apache.axis2.clustering.tribes.TribesUtil;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.PhaseRule;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.DispatchPhase;
import org.apache.axis2.engine.Phase;
import org.apache.catalina.tribes.Channel;
import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.ChannelInterceptor;
import org.apache.catalina.tribes.ManagedChannel;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.MembershipListener;
import org.apache.catalina.tribes.group.GroupChannel;
import org.apache.catalina.tribes.group.Response;
import org.apache.catalina.tribes.group.RpcCallback;
import org.apache.catalina.tribes.group.RpcChannel;
import org.apache.catalina.tribes.group.interceptors.DomainFilterInterceptor;
import org.apache.catalina.tribes.group.interceptors.OrderInterceptor;
import org.apache.catalina.tribes.group.interceptors.TcpFailureDetector;
import org.apache.catalina.tribes.transport.MultiPointSender;
import org.apache.catalina.tribes.transport.ReceiverBase;
import org.apache.catalina.tribes.transport.ReplicationTransmitter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TribesClusterManager
implements ClusterManager {
    public static final int MSG_ORDER_OPTION = 512;
    private static final Log log = LogFactory.getLog((Class)TribesClusterManager.class);
    private DefaultConfigurationManager configurationManager;
    private DefaultContextManager contextManager;
    private HashMap parameters = new HashMap();
    private ManagedChannel channel;
    private RpcChannel rpcChannel;
    private ConfigurationContext configurationContext;
    private ControlCommandProcessor controlCmdProcessor = new ControlCommandProcessor(this.configurationContext);
    private ChannelListener channelListener;
    private ChannelSender channelSender;
    private MembershipManager membershipManager;

    public ContextManager getContextManager() {
        return this.contextManager;
    }

    public ConfigurationManager getConfigurationManager() {
        return this.configurationManager;
    }

    public void init() throws ClusteringFault {
        Parameter domainParam;
        HandlerDescription handlerDesc;
        PhaseRule rule;
        RequestBlockingHandler requestBlockingHandler;
        Phase phase;
        AxisConfiguration axisConfig = this.configurationContext.getAxisConfiguration();
        Iterator iterator = axisConfig.getInFlowPhases().iterator();
        while (iterator.hasNext()) {
            phase = (Phase)iterator.next();
            if (!(phase instanceof DispatchPhase)) continue;
            requestBlockingHandler = new RequestBlockingHandler();
            if (phase.getHandlers().contains(requestBlockingHandler)) break;
            rule = new PhaseRule("Dispatch");
            rule.setAfter("SOAPMessageBodyBasedDispatcher");
            rule.setBefore("InstanceDispatcher");
            handlerDesc = requestBlockingHandler.getHandlerDesc();
            handlerDesc.setHandler(requestBlockingHandler);
            handlerDesc.setName("RequestBlockingHandler");
            handlerDesc.setRules(rule);
            phase.addHandler(requestBlockingHandler);
            break;
        }
        iterator = axisConfig.getInFaultFlowPhases().iterator();
        while (iterator.hasNext()) {
            phase = (Phase)iterator.next();
            if (!(phase instanceof DispatchPhase)) continue;
            requestBlockingHandler = new RequestBlockingHandler();
            if (phase.getHandlers().contains(requestBlockingHandler)) continue;
            rule = new PhaseRule("Dispatch");
            rule.setAfter("SOAPMessageBodyBasedDispatcher");
            rule.setBefore("InstanceDispatcher");
            handlerDesc = requestBlockingHandler.getHandlerDesc();
            handlerDesc.setHandler(requestBlockingHandler);
            handlerDesc.setName("RequestBlockingHandler");
            handlerDesc.setRules(rule);
            phase.addHandler(requestBlockingHandler);
            break;
        }
        this.membershipManager = new MembershipManager();
        this.channel = new GroupChannel();
        this.channelSender = new ChannelSender((Channel)this.channel, this.membershipManager, this.synchronizeAllMembers());
        this.channelListener = new ChannelListener(this.configurationContext, this.configurationManager, this.contextManager, this.controlCmdProcessor);
        Parameter maxRetriesParam = this.getParameter("maxRetries");
        int maxRetries = 10;
        if (maxRetriesParam != null) {
            maxRetries = Integer.parseInt((String)maxRetriesParam.getValue());
        }
        ReplicationTransmitter replicationTransmitter = (ReplicationTransmitter)this.channel.getChannelSender();
        MultiPointSender multiPointSender = replicationTransmitter.getTransport();
        multiPointSender.setMaxRetryAttempts(maxRetries);
        String localIP = System.getProperty("axis2.local.ip.address");
        if (localIP != null) {
            ReceiverBase receiver = (ReceiverBase)this.channel.getChannelReceiver();
            receiver.setAddress(localIP);
        }
        byte[] domain = (domainParam = this.getParameter("domain")) != null ? ((String)domainParam.getValue()).getBytes() : "apache.axis2.domain".getBytes();
        this.channel.getMembershipService().setDomain(domain);
        DomainFilterInterceptor dfi = new DomainFilterInterceptor();
        dfi.setDomain(domain);
        this.channel.addInterceptor((ChannelInterceptor)dfi);
        OrderInterceptor orderInterceptor = new OrderInterceptor();
        orderInterceptor.setOptionFlag(512);
        this.channel.addInterceptor((ChannelInterceptor)orderInterceptor);
        AtMostOnceInterceptor atMostOnceInterceptor = new AtMostOnceInterceptor();
        this.channel.addInterceptor((ChannelInterceptor)atMostOnceInterceptor);
        TcpFailureDetector tcpFailureDetector = new TcpFailureDetector();
        tcpFailureDetector.setPrevious((ChannelInterceptor)dfi);
        this.channel.addInterceptor((ChannelInterceptor)tcpFailureDetector);
        this.channel.addChannelListener((org.apache.catalina.tribes.ChannelListener)this.channelListener);
        TribesMembershipListener membershipListener = new TribesMembershipListener(this.membershipManager);
        this.channel.addMembershipListener((MembershipListener)membershipListener);
        try {
            this.channel.start(15);
            String localHost = TribesUtil.getLocalHost((Channel)this.channel);
            if (localHost.startsWith("127.0.")) {
                this.channel.stop(15);
                throw new ClusteringFault("Cannot join cluster using IP " + localHost + ". Please set an IP address other than " + localHost + " in your /etc/hosts file or set the " + "axis2.local.ip.address" + " System property and retry.");
            }
        }
        catch (ChannelException e) {
            throw new ClusteringFault("Error starting Tribes channel", (Exception)((Object)e));
        }
        RpcChannel rpcChannel = new RpcChannel(domain, (Channel)this.channel, (RpcCallback)new InitializationRequestHandler(this.controlCmdProcessor));
        log.info((Object)("Local Member " + TribesUtil.getLocalHost((Channel)this.channel)));
        TribesUtil.printMembers(this.membershipManager);
        if (this.configurationManager != null) {
            this.configurationManager.setSender(this.channelSender);
            this.initializeSystem(rpcChannel, new GetConfigurationCommand());
        }
        if (this.contextManager != null) {
            this.contextManager.setSender(this.channelSender);
            this.channelListener.setContextManager(this.contextManager);
            this.initializeSystem(rpcChannel, new GetStateCommand());
            ClusteringContextListener contextListener = new ClusteringContextListener(this.channelSender);
            this.configurationContext.addContextListener(contextListener);
        }
        this.configurationContext.setNonReplicableProperty("local_cluster.initialized", "true");
    }

    private void initializeSystem(RpcChannel rpcChannel, ControlCommand command) throws ClusteringFault {
        int numberOfTries = 0;
        ArrayList<String> sentMembersList = new ArrayList<String>();
        sentMembersList.add(TribesUtil.getLocalHost((Channel)this.channel));
        Member[] members = this.membershipManager.getMembers();
        if (members.length == 0) {
            return;
        }
        while (members.length > 0 && numberOfTries < 5) {
            Member member = numberOfTries == 0 ? this.membershipManager.getLongestLivingMember() : this.membershipManager.getRandomMember();
            String memberHost = TribesUtil.getHost(member);
            try {
                Response[] responses;
                if (!sentMembersList.contains(memberHost) && (responses = rpcChannel.send(new Member[]{member}, (Serializable)command, 1, 8, 10000L)).length > 0) {
                    ((ControlCommand)responses[0].getMessage()).execute(this.configurationContext);
                    break;
                }
            }
            catch (ChannelException e) {
                log.error((Object)("Cannot get initialization information from " + memberHost + ". Will retry in 2 secs."), (Throwable)e);
                sentMembersList.add(memberHost);
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ignored) {
                    log.debug((Object)"Interrupted", (Throwable)ignored);
                }
            }
            if (++numberOfTries < (members = this.membershipManager.getMembers()).length) continue;
            break;
        }
    }

    public void setConfigurationManager(ConfigurationManager configurationManager) {
        this.configurationManager = (DefaultConfigurationManager)configurationManager;
        this.configurationManager.setSender(this.channelSender);
    }

    public void setContextManager(ContextManager contextManager) {
        this.contextManager = (DefaultContextManager)contextManager;
        this.contextManager.setSender(this.channelSender);
    }

    public void addParameter(Parameter param) throws AxisFault {
        this.parameters.put(param.getName(), param);
    }

    public void deserializeParameters(OMElement parameterElement) throws AxisFault {
        throw new UnsupportedOperationException();
    }

    public Parameter getParameter(String name) {
        return (Parameter)this.parameters.get(name);
    }

    public ArrayList getParameters() {
        ArrayList list = new ArrayList();
        Iterator it = this.parameters.keySet().iterator();
        while (it.hasNext()) {
            list.add(this.parameters.get(it.next()));
        }
        return list;
    }

    public boolean isParameterLocked(String parameterName) {
        Parameter parameter = (Parameter)this.parameters.get(parameterName);
        return parameter != null && parameter.isLocked();
    }

    public void removeParameter(Parameter param) throws AxisFault {
        this.parameters.remove(param.getName());
    }

    public void shutdown() throws ClusteringFault {
        log.debug((Object)"Enter: TribesClusterManager::shutdown");
        if (this.channel != null) {
            try {
                this.channel.removeChannelListener((org.apache.catalina.tribes.ChannelListener)this.rpcChannel);
                this.channel.removeChannelListener((org.apache.catalina.tribes.ChannelListener)this.channelListener);
                this.channel.stop(15);
            }
            catch (ChannelException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Exit: TribesClusterManager::shutdown");
                }
                throw new ClusteringFault((Exception)((Object)e));
            }
        }
        log.debug((Object)"Exit: TribesClusterManager::shutdown");
    }

    public void setConfigurationContext(ConfigurationContext configurationContext) {
        this.configurationContext = configurationContext;
        this.controlCmdProcessor.setConfigurationContext(configurationContext);
        if (this.channelListener != null) {
            this.channelListener.setConfigurationContext(configurationContext);
        }
        if (this.configurationManager != null) {
            this.configurationManager.setConfigurationContext(configurationContext);
        }
        if (this.contextManager != null) {
            this.contextManager.setConfigurationContext(configurationContext);
        }
    }

    public boolean synchronizeAllMembers() {
        Parameter syncAllParam = this.getParameter("synchronizeAll");
        return syncAllParam == null || Boolean.parseBoolean((String)syncAllParam.getValue());
    }
}

