/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.client;

import java.net.URL;
import java.util.ArrayList;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.OperationClient;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.async.AxisCallback;
import org.apache.axis2.client.async.Callback;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.OutInAxisOperation;
import org.apache.axis2.description.OutOnlyAxisOperation;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.RobustOutOnlyAxisOperation;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.ListenerManager;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.util.Counter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServiceClient {
    protected static final Log log = LogFactory.getLog((Class)ServiceClient.class);
    public static final String ANON_SERVICE = "anonService";
    private static Counter anonServiceCounter = new Counter();
    public static final QName ANON_OUT_ONLY_OP = new QName("anonOutonlyOp");
    public static final QName ANON_ROBUST_OUT_ONLY_OP = new QName("anonRobustOp");
    public static final QName ANON_OUT_IN_OP = new QName("anonOutInOp");
    private AxisService axisService;
    private AxisConfiguration axisConfig;
    private ConfigurationContext configContext;
    private ServiceContext serviceContext;
    private Options options = new Options();
    private Options overrideOptions;
    private ArrayList headers;
    private boolean createConfigCtx;

    public ServiceClient(ConfigurationContext configContext, AxisService axisService) throws AxisFault {
        this.configureServiceClient(configContext, axisService);
    }

    private void configureServiceClient(ConfigurationContext configContext, AxisService axisService) throws AxisFault {
        if (configContext == null) {
            if (ListenerManager.defaultConfigurationContext == null) {
                configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem(null, null);
                this.createConfigCtx = true;
            } else {
                configContext = ListenerManager.defaultConfigurationContext;
            }
        }
        this.configContext = configContext;
        ListenerManager transportManager = configContext.getListenerManager();
        if (transportManager == null) {
            transportManager = new ListenerManager();
            transportManager.init(this.configContext);
        }
        this.axisConfig = configContext.getAxisConfiguration();
        if (axisService == null) {
            axisService = this.createAnonymousService();
        }
        this.axisService = axisService;
        if (this.axisConfig.getService(axisService.getName()) != null) {
            throw new AxisFault(Messages.getMessage("twoservicecannothavesamename", axisService.getName()));
        }
        axisService.setClientSide(true);
        this.axisConfig.addService(axisService);
        AxisServiceGroup axisServiceGroup = axisService.getAxisServiceGroup();
        ServiceGroupContext sgc = configContext.createServiceGroupContext(axisServiceGroup);
        this.serviceContext = sgc.getServiceContext(axisService);
    }

    public ServiceClient(ConfigurationContext configContext, Definition wsdl4jDefinition, QName wsdlServiceName, String portName) throws AxisFault {
        this.configureServiceClient(configContext, AxisService.createClientSideAxisService(wsdl4jDefinition, wsdlServiceName, portName, this.options));
    }

    public ServiceClient(ConfigurationContext configContext, URL wsdlURL, QName wsdlServiceName, String portName) throws AxisFault {
        this.configureServiceClient(configContext, AxisService.createClientSideAxisService(wsdlURL, wsdlServiceName, portName, this.options));
        Parameter transportName = this.axisService.getParameter("TRANSPORT_NAME");
        if (transportName != null) {
            TransportOutDescription transportOut = configContext.getAxisConfiguration().getTransportOut(transportName.getValue().toString());
            if (transportOut == null) {
                throw new AxisFault("Cannot load transport from binding, either defin in Axis2.config or set it explicitely in ServiceClinet.Options");
            }
            this.options.setTransportOut(transportOut);
        }
    }

    public ServiceClient() throws AxisFault {
        this(null, null);
    }

    private AxisService createAnonymousService() {
        AxisService axisService = new AxisService(ANON_SERVICE + anonServiceCounter.incrementAndGet());
        RobustOutOnlyAxisOperation robustoutoonlyOperation = new RobustOutOnlyAxisOperation(ANON_ROBUST_OUT_ONLY_OP);
        axisService.addOperation(robustoutoonlyOperation);
        OutOnlyAxisOperation outOnlyOperation = new OutOnlyAxisOperation(ANON_OUT_ONLY_OP);
        axisService.addOperation(outOnlyOperation);
        OutInAxisOperation outInOperation = new OutInAxisOperation(ANON_OUT_IN_OP);
        axisService.addOperation(outInOperation);
        return axisService;
    }

    public AxisConfiguration getAxisConfiguration() {
        return this.axisConfig;
    }

    public AxisService getAxisService() {
        return this.axisService;
    }

    public void setOptions(Options options) {
        this.options = options;
    }

    public Options getOptions() {
        return this.options;
    }

    public void setOverrideOptions(Options overrideOptions) {
        this.overrideOptions = overrideOptions;
    }

    public Options getOverrideOptions() {
        return this.overrideOptions;
    }

    public void engageModule(QName moduleName) throws AxisFault {
        this.engageModule(moduleName.getLocalPart());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engageModule(String moduleName) throws AxisFault {
        ServiceClient serviceClient = this;
        synchronized (serviceClient) {
            AxisModule module = this.axisConfig.getModule(moduleName);
            if (module == null) {
                throw new AxisFault("Unable to engage module : " + moduleName);
            }
            this.axisService.engageModule(module);
        }
    }

    public void disengageModule(QName moduleName) {
        this.disengageModule(moduleName.getLocalPart());
    }

    public void disengageModule(String moduleName) {
        AxisModule module = this.axisConfig.getModule(moduleName);
        if (module != null) {
            try {
                this.axisService.disengageModule(module);
            }
            catch (AxisFault axisFault) {
                log.error((Object)axisFault.getMessage(), (Throwable)axisFault);
            }
        }
    }

    public void addHeader(OMElement header) {
        if (this.headers == null) {
            this.headers = new ArrayList();
        }
        this.headers.add(header);
    }

    public void addHeader(SOAPHeaderBlock header) {
        if (this.headers == null) {
            this.headers = new ArrayList();
        }
        this.headers.add(header);
    }

    public void removeHeaders() {
        if (this.headers != null) {
            this.headers.clear();
        }
    }

    public void addStringHeader(QName headerName, String headerText) throws AxisFault {
        if (headerName.getNamespaceURI() == null || "".equals(headerName.getNamespaceURI())) {
            throw new AxisFault("Failed to add string header, you have to have namespaceURI for the QName");
        }
        OMElement omElement = OMAbstractFactory.getOMFactory().createOMElement(headerName, null);
        omElement.setText(headerText);
        this.addHeader(omElement);
    }

    public void sendRobust(OMElement elem) throws AxisFault {
        this.sendRobust(ANON_ROBUST_OUT_ONLY_OP, elem);
    }

    public void sendRobust(QName operation, OMElement elem) throws AxisFault {
        MessageContext mc = new MessageContext();
        this.fillSOAPEnvelope(mc, elem);
        OperationClient mepClient = this.createClient(operation);
        mepClient.addMessageContext(mc);
        mepClient.execute(true);
    }

    public void fireAndForget(OMElement elem) throws AxisFault {
        this.fireAndForget(ANON_OUT_ONLY_OP, elem);
    }

    public void fireAndForget(QName operation, OMElement elem) throws AxisFault {
        OperationClient mepClient = this.createClient(operation);
        MessageContext mc = new MessageContext();
        this.fillSOAPEnvelope(mc, elem);
        mepClient.addMessageContext(mc);
        mepClient.execute(false);
    }

    public OMElement sendReceive(OMElement elem) throws AxisFault {
        return this.sendReceive(ANON_OUT_IN_OP, elem);
    }

    public OMElement sendReceive(QName operationQName, OMElement xmlPayload) throws AxisFault {
        MessageContext messageContext = new MessageContext();
        this.fillSOAPEnvelope(messageContext, xmlPayload);
        OperationClient operationClient = this.createClient(operationQName);
        operationClient.addMessageContext(messageContext);
        operationClient.execute(true);
        MessageContext response = operationClient.getMessageContext("In");
        if (this.options.isCallTransportCleanup()) {
            response.getEnvelope().build();
            this.cleanupTransport();
            return response.getEnvelope().getBody().getFirstElement();
        }
        return response.getEnvelope().getBody().getFirstElement();
    }

    public void sendReceiveNonBlocking(OMElement elem, Callback callback) throws AxisFault {
        this.sendReceiveNonBlocking(ANON_OUT_IN_OP, elem, callback);
    }

    public void sendReceiveNonBlocking(OMElement elem, AxisCallback callback) throws AxisFault {
        this.sendReceiveNonBlocking(ANON_OUT_IN_OP, elem, callback);
    }

    public void sendReceiveNonBlocking(QName operation, OMElement elem, Callback callback) throws AxisFault {
        MessageContext mc = new MessageContext();
        this.fillSOAPEnvelope(mc, elem);
        OperationClient mepClient = this.createClient(operation);
        mepClient.setCallback(callback);
        mepClient.addMessageContext(mc);
        mepClient.execute(false);
    }

    public void sendReceiveNonBlocking(QName operation, OMElement elem, AxisCallback callback) throws AxisFault {
        MessageContext mc = new MessageContext();
        this.fillSOAPEnvelope(mc, elem);
        OperationClient mepClient = this.createClient(operation);
        mepClient.setCallback(callback);
        mepClient.addMessageContext(mc);
        mepClient.execute(false);
    }

    public OperationClient createClient(QName operationQName) throws AxisFault {
        AxisOperation axisOperation = this.axisService.getOperation(operationQName);
        if (axisOperation == null) {
            throw new AxisFault(Messages.getMessage("operationnotfound", operationQName.getLocalPart()));
        }
        OperationClient operationClient = axisOperation.createClient(this.serviceContext, this.options);
        if (this.overrideOptions != null) {
            this.overrideOptions.setParent(operationClient.getOptions());
            operationClient.setOptions(this.overrideOptions);
        }
        return operationClient;
    }

    private SOAPFactory getSOAPFactory() {
        String soapVersionURI = this.options.getSoapVersionURI();
        if ("http://www.w3.org/2003/05/soap-envelope".equals(soapVersionURI)) {
            return OMAbstractFactory.getSOAP12Factory();
        }
        return OMAbstractFactory.getSOAP11Factory();
    }

    private void fillSOAPEnvelope(MessageContext messageContext, OMElement xmlPayload) throws AxisFault {
        messageContext.setServiceContext(this.serviceContext);
        SOAPFactory soapFactory = this.getSOAPFactory();
        SOAPEnvelope envelope = soapFactory.getDefaultEnvelope();
        if (xmlPayload != null) {
            envelope.getBody().addChild((OMNode)xmlPayload);
        }
        this.addHeadersToEnvelope(envelope);
        messageContext.setEnvelope(envelope);
    }

    public void addHeadersToEnvelope(SOAPEnvelope envelope) {
        if (this.headers != null) {
            SOAPHeader soapHeader = envelope.getHeader();
            for (int i = 0; i < this.headers.size(); ++i) {
                soapHeader.addChild((OMNode)((OMElement)this.headers.get(i)));
            }
        }
    }

    public EndpointReference getMyEPR(String transport) throws AxisFault {
        return this.serviceContext.getMyEPR(transport);
    }

    public EndpointReference getTargetEPR() {
        return this.serviceContext.getTargetEPR();
    }

    public void setTargetEPR(EndpointReference targetEpr) {
        this.serviceContext.setTargetEPR(targetEpr);
        this.options.setTo(targetEpr);
    }

    public OperationContext getLastOperationContext() {
        return this.serviceContext.getLastOperationContext();
    }

    public void setCachingOperationContext(boolean cachingOpContext) {
        this.serviceContext.setCachingOperationContext(cachingOpContext);
    }

    public ServiceContext getServiceContext() {
        return this.serviceContext;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.cleanup();
    }

    public void cleanup() throws AxisFault {
        if (!this.createConfigCtx) {
            String serviceGroupName = this.axisService.getAxisServiceGroup().getServiceGroupName();
            AxisConfiguration axisConfiguration = this.configContext.getAxisConfiguration();
            AxisServiceGroup asg = axisConfiguration.getServiceGroup(serviceGroupName);
            if (asg != null) {
                axisConfiguration.removeServiceGroup(serviceGroupName);
            }
        } else {
            this.configContext.terminate();
        }
    }

    public void cleanupTransport() throws AxisFault {
        MessageContext outMessageContext;
        if (this.getLastOperationContext() != null && (outMessageContext = this.getLastOperationContext().getMessageContext("Out")) != null) {
            outMessageContext.getTransportOut().getSender().cleanup(outMessageContext);
        }
    }

    public void setAxisService(AxisService axisService) throws AxisFault {
        if (axisService == null) {
            throw new IllegalArgumentException("AxisService is null");
        }
        this.axisConfig.removeService(this.axisService.getName());
        this.axisService = axisService;
        axisService.setClientSide(true);
        this.axisConfig.addService(axisService);
        AxisServiceGroup axisServiceGroup = axisService.getAxisServiceGroup();
        ServiceGroupContext serviceGroupContext = this.configContext.createServiceGroupContext(axisServiceGroup);
        this.serviceContext = serviceGroupContext.getServiceContext(axisService);
    }
}

