/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.builder;

import java.io.InputStream;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.Builder;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.context.MessageContext;

public class MIMEBuilder
implements Builder {
    public OMElement processDocument(InputStream inputStream, String contentType, MessageContext msgContext) throws AxisFault {
        Attachments attachments = BuilderUtil.createAttachmentsMap(msgContext, inputStream, contentType);
        String charSetEncoding = BuilderUtil.getCharSetEncoding(attachments.getSOAPPartContentType());
        if (charSetEncoding == null || "null".equalsIgnoreCase(charSetEncoding)) {
            charSetEncoding = "UTF-8";
        }
        msgContext.setProperty("CHARACTER_SET_ENCODING", charSetEncoding);
        msgContext.setProperty("Attachments", attachments);
        msgContext.setAttachmentMap(attachments);
        msgContext.setDoingSwA(true);
        Builder builder = BuilderUtil.getBuilderFromSelector(attachments.getAttachmentSpecType(), msgContext);
        OMElement element = builder.processDocument(attachments.getSOAPPartInputStream(), contentType, msgContext);
        return element;
    }
}

