/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2ddl;

import java.io.FileInputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.cfg.Settings;
import org.hibernate.dialect.Dialect;
import org.hibernate.tool.hbm2ddl.ConnectionHelper;
import org.hibernate.tool.hbm2ddl.DatabaseMetadata;
import org.hibernate.tool.hbm2ddl.ManagedProviderConnectionHelper;
import org.hibernate.tool.hbm2ddl.SuppliedConnectionProviderConnectionHelper;
import org.hibernate.util.ReflectHelper;

public class SchemaUpdate {
    private static final Log log = LogFactory.getLog((Class)SchemaUpdate.class);
    private ConnectionHelper connectionHelper;
    private Configuration configuration;
    private Dialect dialect;
    private List exceptions;

    public SchemaUpdate(Configuration cfg) throws HibernateException {
        this(cfg, cfg.getProperties());
    }

    public SchemaUpdate(Configuration cfg, Properties connectionProperties) throws HibernateException {
        this.configuration = cfg;
        this.dialect = Dialect.getDialect(connectionProperties);
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.dialect.getDefaultProperties());
        props.putAll((Map<?, ?>)connectionProperties);
        this.connectionHelper = new ManagedProviderConnectionHelper(props);
        this.exceptions = new ArrayList();
    }

    public SchemaUpdate(Configuration cfg, Settings settings) throws HibernateException {
        this.configuration = cfg;
        this.dialect = settings.getDialect();
        this.connectionHelper = new SuppliedConnectionProviderConnectionHelper(settings.getConnectionProvider());
        this.exceptions = new ArrayList();
    }

    public static void main(String[] args) {
        try {
            Configuration cfg = new Configuration();
            boolean script = true;
            boolean doUpdate = true;
            String propFile = null;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].startsWith("--")) {
                    if (args[i].equals("--quiet")) {
                        script = false;
                        continue;
                    }
                    if (args[i].startsWith("--properties=")) {
                        propFile = args[i].substring(13);
                        continue;
                    }
                    if (args[i].startsWith("--config=")) {
                        cfg.configure(args[i].substring(9));
                        continue;
                    }
                    if (args[i].startsWith("--text")) {
                        doUpdate = false;
                        continue;
                    }
                    if (!args[i].startsWith("--naming=")) continue;
                    cfg.setNamingStrategy((NamingStrategy)ReflectHelper.classForName(args[i].substring(9)).newInstance());
                    continue;
                }
                cfg.addFile(args[i]);
            }
            if (propFile != null) {
                Properties props = new Properties();
                props.putAll((Map<?, ?>)cfg.getProperties());
                props.load(new FileInputStream(propFile));
                cfg.setProperties(props);
            }
            new SchemaUpdate(cfg).execute(script, doUpdate);
        }
        catch (Exception e) {
            log.error((Object)"Error running schema update", (Throwable)e);
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void execute(boolean script, boolean doUpdate) {
        block17: {
            DatabaseMetadata meta;
            log.info((Object)"Running hbm2ddl schema update");
            Connection connection = null;
            Statement stmt = null;
            this.exceptions.clear();
            try {
                log.info((Object)"fetching database metadata");
                this.connectionHelper.prepare(true);
                connection = this.connectionHelper.getConnection();
                meta = new DatabaseMetadata(connection, this.dialect);
                stmt = connection.createStatement();
            }
            catch (SQLException sqle) {
                this.exceptions.add(sqle);
                log.error((Object)"could not get database metadata", (Throwable)sqle);
                throw sqle;
            }
            log.info((Object)"updating schema");
            String[] createSQL = this.configuration.generateSchemaUpdateScript(this.dialect, meta);
            for (int j = 0; j < createSQL.length; ++j) {
                String sql = createSQL[j];
                try {
                    if (script) {
                        System.out.println(sql);
                    }
                    if (!doUpdate) continue;
                    log.debug((Object)sql);
                    stmt.executeUpdate(sql);
                    continue;
                }
                catch (SQLException e) {
                    this.exceptions.add(e);
                    log.error((Object)("Unsuccessful: " + sql));
                    log.error((Object)e.getMessage());
                }
            }
            log.info((Object)"schema update complete");
            Object var11_12 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                this.connectionHelper.release();
            }
            catch (Exception e2) {
                this.exceptions.add(e2);
                log.error((Object)"Error closing connection", (Throwable)e2);
            }
            break block17;
            {
                catch (Exception e) {
                    this.exceptions.add(e);
                    log.error((Object)"could not complete schema update", (Throwable)e);
                    Object var11_13 = null;
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                        this.connectionHelper.release();
                    }
                    catch (Exception e2) {
                        this.exceptions.add(e2);
                        log.error((Object)"Error closing connection", (Throwable)e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    this.connectionHelper.release();
                }
                catch (Exception e2) {
                    this.exceptions.add(e2);
                    log.error((Object)"Error closing connection", (Throwable)e2);
                }
                throw throwable;
            }
        }
    }

    public List getExceptions() {
        return this.exceptions;
    }
}

