/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.adminui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.adminui.UIProcessingException;

public class UIProcessor {
    private static Log log = LogFactory.getLog((Class)UIProcessor.class);
    private static final QName FILE_QN = new QName("file");
    private static final QName FILES_QN = new QName("files");
    private static final QName EXTENSIONS_ORDER_QN = new QName("extension-order");
    private static final QName FILE_MAPPINGS_QN = new QName("file-mappings");
    private static final QName ITEM_QN = new QName("item");
    private static final QName MAPPING_QN = new QName("mapping");
    private static final QName TOKEN_QN = new QName("token");
    private static final String UI_EXTENSION_CONFIG_FILE = "ui-extensions-config.xml";

    public static void createPages(String resourceBase, String configFileName, Map mainFileMap) throws UIProcessingException {
        OMElement documentElement;
        InputStream inStream;
        if (configFileName == null) {
            configFileName = UI_EXTENSION_CONFIG_FILE;
        }
        if ((inStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(configFileName)) == null) {
            throw new UIProcessingException(configFileName + " file not found in classpath");
        }
        try {
            documentElement = new StAXOMBuilder(inStream).getDocumentElement();
        }
        catch (XMLStreamException e) {
            throw new UIProcessingException(e);
        }
        ArrayList files = new ArrayList();
        ArrayList orderedExts = new ArrayList();
        HashMap mappings = new HashMap();
        UIProcessor.parseFiles(documentElement, files);
        UIProcessor.parseExtensionOrder(documentElement, orderedExts);
        UIProcessor.parseFileMappings(documentElement, mappings, orderedExts, resourceBase);
        Iterator fileIterator = files.iterator();
        while (fileIterator.hasNext()) {
            String fileContents;
            String mainFileName = (String)fileIterator.next();
            try {
                fileContents = UIProcessor.getFileStr(resourceBase, mainFileName);
            }
            catch (IOException e) {
                throw new UIProcessingException(e);
            }
            Iterator mappingIterator = mappings.keySet().iterator();
            while (mappingIterator.hasNext()) {
                String token = (String)mappingIterator.next();
                fileContents = fileContents.replaceAll(token, (String)mappings.get(token));
            }
            if (fileContents == null) continue;
            mainFileMap.put(mainFileName, fileContents);
        }
    }

    private static void parseFiles(OMElement documentElement, Collection filesCollection) {
        OMElement filesElement = documentElement.getFirstChildWithName(FILES_QN);
        Iterator fileIterator = filesElement.getChildrenWithName(FILE_QN);
        while (fileIterator.hasNext()) {
            OMElement file = (OMElement)fileIterator.next();
            filesCollection.add(file.getText());
        }
    }

    private static void parseFileMappings(OMElement documentElement, Map fileMappingMap, Collection orderedExts, String resourceBase) {
        OMElement fileMappingElement = documentElement.getFirstChildWithName(FILE_MAPPINGS_QN);
        Iterator mappingIterator = fileMappingElement.getChildrenWithName(MAPPING_QN);
        while (mappingIterator.hasNext()) {
            OMElement mapping = (OMElement)mappingIterator.next();
            OMElement tokenEle = mapping.getFirstChildWithName(TOKEN_QN);
            OMElement filesEle = mapping.getFirstChildWithName(FILE_QN);
            String convertedFileToString = UIProcessor.convertMappingFileToString(resourceBase, filesEle.getText(), orderedExts);
            fileMappingMap.put(tokenEle.getText(), convertedFileToString);
        }
    }

    private static void parseExtensionOrder(OMElement documentElement, Collection extensionCollection) {
        OMElement extensionOrderElement = documentElement.getFirstChildWithName(EXTENSIONS_ORDER_QN);
        Iterator itemIterator = extensionOrderElement.getChildrenWithName(ITEM_QN);
        while (itemIterator.hasNext()) {
            OMElement item = (OMElement)itemIterator.next();
            extensionCollection.add(item.getText());
        }
    }

    private static String getFileStr(String resourceBase, String fileName) throws IOException {
        byte[] bytes;
        File file = new File(resourceBase + "/" + fileName);
        FileInputStream fis = new FileInputStream(file);
        int length = fis.read(bytes = new byte[(int)file.length()]);
        if (length == 0) {
            log.warn((Object)(fileName + " read is 0 bytes"));
        }
        return new String(bytes);
    }

    private static String convertMappingFileToString(String resourceBase, String mappingFile, Collection orderedExts) {
        String finalContentet = "";
        Iterator fileCollectionIterator = orderedExts.iterator();
        while (fileCollectionIterator.hasNext()) {
            String extension = (String)fileCollectionIterator.next();
            try {
                File menuHTML = new File(resourceBase + "/extensions/" + extension + "/" + mappingFile);
                if (!menuHTML.exists()) continue;
                FileInputStream fis2 = new FileInputStream(menuHTML);
                byte[] bytesMenusHtml = new byte[(int)menuHTML.length()];
                int length = fis2.read(bytesMenusHtml);
                if (length == 0) {
                    log.warn((Object)(menuHTML + " read is 0 bytes"));
                }
                finalContentet = finalContentet + new String(bytesMenusHtml);
            }
            catch (FileNotFoundException e) {
                log.error((Object)(mappingFile + " file not found for UI extension " + extension + e));
            }
            catch (IOException e) {
                log.error((Object)e);
            }
        }
        File[] unorderedExtensions = new File(resourceBase + "/extensions").listFiles();
        if (unorderedExtensions != null) {
            for (int i = 0; i < unorderedExtensions.length; ++i) {
                File dir;
                String extension = unorderedExtensions[i].getName();
                if (orderedExts.contains(extension) || !(dir = new File(resourceBase + "/extensions/" + extension)).isDirectory()) continue;
                try {
                    File menuHTML = new File(resourceBase + "/extensions/" + extension + "/" + mappingFile);
                    if (!menuHTML.exists()) continue;
                    FileInputStream fis2 = new FileInputStream(menuHTML);
                    byte[] bytesMenusHtml = new byte[(int)menuHTML.length()];
                    int length = fis2.read(bytesMenusHtml);
                    if (length == 0) {
                        log.warn((Object)(menuHTML + " read is 0 bytes"));
                    }
                    finalContentet = finalContentet + new String(bytesMenusHtml);
                    continue;
                }
                catch (FileNotFoundException e) {
                    log.error((Object)e);
                    continue;
                }
                catch (IOException e) {
                    log.error((Object)e);
                }
            }
        }
        return finalContentet;
    }
}

