/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.adminui;

import java.io.IOException;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AdminUIServletFilter
implements Filter {
    protected static final Log log = LogFactory.getLog((Class)AdminUIServletFilter.class);
    private ServletContext servletContext;
    private FilterConfig filterConfig;
    private String contextRoot;
    private String adminConsoleContextRoot;
    private static final String APPLICATION_CONTEXT_ROOT = "application.context.root";
    private static final String GLOBAL_PARAMS_JS = "global_params.js";

    public void init() throws ServletException {
        if (this.filterConfig != null) {
            this.init(this.filterConfig);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.adminConsoleContextRoot = filterConfig.getInitParameter(APPLICATION_CONTEXT_ROOT);
        if (this.adminConsoleContextRoot != null && this.adminConsoleContextRoot.equals("/")) {
            this.adminConsoleContextRoot = "";
        }
        this.filterConfig = filterConfig;
        this.servletContext = filterConfig.getServletContext();
        this.servletContext.setAttribute(this.getClass().getName(), (Object)this);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        try {
            HttpServletRequest httpServletRequest = (HttpServletRequest)request;
            if (this.contextRoot == null) {
                this.contextRoot = httpServletRequest.getContextPath();
            }
            String requestURI = httpServletRequest.getRequestURI();
            int indexOfDot = requestURI.lastIndexOf(".");
            boolean isFile = false;
            if (indexOfDot != -1) {
                isFile = requestURI.substring(indexOfDot).matches("\\.(.)*");
            }
            if (!isFile && requestURI.lastIndexOf("/") != requestURI.length() - 1) {
                requestURI = requestURI + "/";
            }
            Map generatedPages = (Map)this.servletContext.getAttribute("geneated.pages");
            if (requestURI.equals(this.contextRoot) || requestURI.equals(this.contextRoot + "/")) {
                response.setContentType("text/html");
                boolean enableConsole = (Boolean)this.servletContext.getAttribute("enable.console");
                if (!enableConsole) {
                    ServletOutputStream out = response.getOutputStream();
                    out.write("<b>Management Console has been disabled.</b> Enable it in the server.xml and try again.".getBytes());
                    ((HttpServletResponse)response).setStatus(403);
                    out.flush();
                    out.close();
                    return;
                }
                String fileContents = (String)generatedPages.get("index.html");
                if (fileContents != null) {
                    ServletOutputStream op = response.getOutputStream();
                    response.setContentLength(fileContents.getBytes().length);
                    op.write(fileContents.getBytes());
                    return;
                }
            } else {
                String fileContents;
                String urlKey = this.contextRoot.equals("/") ? requestURI.substring(this.contextRoot.length(), requestURI.length()) : requestURI.substring(1 + this.contextRoot.length(), requestURI.length());
                if (generatedPages != null && (fileContents = (String)generatedPages.get(urlKey)) != null) {
                    ServletOutputStream op = response.getOutputStream();
                    response.setContentType("text/html");
                    response.setContentLength(fileContents.getBytes().length);
                    op.write(fileContents.getBytes());
                    return;
                }
                if (urlKey.equals(GLOBAL_PARAMS_JS) || urlKey.indexOf(GLOBAL_PARAMS_JS) > -1) {
                    this.initGlobalParams((HttpServletResponse)response);
                    return;
                }
            }
        }
        catch (Exception e) {
            String msg = "Exception occurred while processing Request";
            log.error((Object)msg, (Throwable)e);
            throw new ServletException(msg, (Throwable)e);
        }
        filterChain.doFilter(request, response);
    }

    private void initGlobalParams(HttpServletResponse response) throws IOException {
        String localContext = "";
        if (this.adminConsoleContextRoot != null) {
            localContext = this.adminConsoleContextRoot;
        } else if (this.contextRoot != null) {
            localContext = this.contextRoot;
        }
        String servletCtxPath = (String)this.servletContext.getAttribute("service.context.path");
        String httpPort = (String)this.servletContext.getAttribute("http.port");
        String httpsPort = (String)this.servletContext.getAttribute("https.port");
        String globalParamString = "SERVICE_PATH = \"" + servletCtxPath + "\";\n" + "ROOT_CONTEXT = \"" + localContext + "\";\n" + "HTTP_PORT = " + httpPort + ";\n" + "HTTPS_PORT = " + httpsPort + ";\n";
        ServletOutputStream op = response.getOutputStream();
        response.setContentType("text/html");
        response.setContentLength(globalParamString.getBytes().length);
        op.write(globalParamString.getBytes());
    }

    public void destroy() {
    }
}

