/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.tracer.service;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.util.Loader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.tracer.module.TracePersister;
import org.wso2.tracer.service.MessageInfo;
import org.wso2.tracer.service.MessagePayload;
import org.wso2.tracer.service.TracerServiceInfo;
import org.wso2.utils.CircularBuffer;

public class TracerService {
    private static Log log = LogFactory.getLog((Class)TracerService.class);

    public TracerServiceInfo getMessages(int numberOfMessages, String filter) throws AxisFault {
        ConfigurationContext configurationContext = MessageContext.getCurrentMessageContext().getConfigurationContext();
        AxisConfiguration axisConfiguration = configurationContext.getAxisConfiguration();
        CircularBuffer msgSeqBuff = (CircularBuffer)configurationContext.getProperty("wso2tracer.msg.seq.buff");
        TracerServiceInfo tracerServiceInfo = new TracerServiceInfo();
        AxisModule axisModule = axisConfiguration.getModule("wso2tracer");
        if (axisModule == null) {
            throw new AxisFault("wso2tracer module is not available");
        }
        Parameter tracePersisterParam = MessageContext.getCurrentMessageContext().getParameter("wso2tracer.trace.persister.impl");
        TracePersister tracePersister = this.getTracePersister(tracePersisterParam);
        tracerServiceInfo.setTracePersister(tracePersister.getClass().getName());
        if (tracePersister.isTracingEnabled()) {
            if (!axisConfiguration.isEngaged(axisModule)) {
                axisConfiguration.engageModule(axisModule);
            }
            tracerServiceInfo.setFlag("ON");
        } else {
            if (axisConfiguration.isEngaged(axisModule)) {
                axisConfiguration.disengageModule(axisModule);
            }
            tracerServiceInfo.setFlag("OFF");
        }
        if (msgSeqBuff == null) {
            tracerServiceInfo.setEmpty(true);
            return tracerServiceInfo;
        }
        Object[] messageObjs = msgSeqBuff.getObjects(numberOfMessages);
        if (messageObjs.length == 0) {
            tracerServiceInfo.setEmpty(true);
            return tracerServiceInfo;
        }
        ArrayList<MessageInfo> msgInfoList = new ArrayList<MessageInfo>();
        boolean filterStatus = filter != null && filter.length() != 0;
        tracerServiceInfo.setFilter(filterStatus);
        for (int i = 0; i < messageObjs.length; ++i) {
            MessageInfo mi = (MessageInfo)messageObjs[i];
            if (filterStatus) {
                MessagePayload miPayload = this.getMessage(mi.getServiceId(), mi.getOperationName(), mi.getMessageSequence());
                if (miPayload.getRequest().indexOf(filter) <= -1) continue;
                msgInfoList.add(mi);
                continue;
            }
            msgInfoList.add(mi);
        }
        if (filterStatus) {
            tracerServiceInfo.setFilterString(filter);
            if (msgInfoList.size() == 0) {
                tracerServiceInfo.setEmpty(true);
                return tracerServiceInfo;
            }
        }
        Collections.reverse(msgInfoList);
        MessageInfo lastMessageInfo = (MessageInfo)msgInfoList.get(0);
        tracerServiceInfo.setMessageInfo(msgInfoList.toArray(new MessageInfo[msgInfoList.size()]));
        MessagePayload lastMsg = this.getMessage(lastMessageInfo.getServiceId(), lastMessageInfo.getOperationName(), lastMessageInfo.getMessageSequence());
        tracerServiceInfo.setLastMessage(lastMsg);
        tracerServiceInfo.setEmpty(false);
        return tracerServiceInfo;
    }

    public TracerServiceInfo setMonitoring(String flag) throws AxisFault {
        if (!flag.equalsIgnoreCase("ON") && !flag.equalsIgnoreCase("OFF")) {
            throw new RuntimeException("IllegalArgument for monitoring status :" + flag);
        }
        TracerServiceInfo tracerServiceInfo = new TracerServiceInfo();
        ConfigurationContext configurationContext = MessageContext.getCurrentMessageContext().getConfigurationContext();
        AxisConfiguration axisConfiguration = configurationContext.getAxisConfiguration();
        AxisModule axisModule = axisConfiguration.getModule("wso2tracer");
        if (axisModule == null) {
            throw new RuntimeException(TracerService.class.getName() + " " + "wso2tracer" + " is not available");
        }
        if (flag.equalsIgnoreCase("ON")) {
            if (!axisConfiguration.isEngaged(axisModule.getName())) {
                try {
                    axisConfiguration.engageModule(axisModule);
                }
                catch (AxisFault axisFault) {
                    log.error((Object)axisFault);
                    throw new RuntimeException(axisFault);
                }
            }
        } else if (flag.equalsIgnoreCase("OFF") && axisConfiguration.isEngaged(axisModule.getName())) {
            axisConfiguration.disengageModule(axisModule);
            configurationContext.removeProperty("wso2tracer.msg.seq.buff");
        }
        Parameter tracePersisterParam = MessageContext.getCurrentMessageContext().getParameter("wso2tracer.trace.persister.impl");
        TracePersister tracePersister = this.getTracePersister(tracePersisterParam);
        tracePersister.saveTraceStatus(flag);
        tracerServiceInfo.setEmpty(true);
        tracerServiceInfo.setFlag(flag);
        return tracerServiceInfo;
    }

    public MessagePayload getMessage(String serviceId, String operationName, long messageSequence) throws AxisFault {
        Parameter tracePersisterParam = MessageContext.getCurrentMessageContext().getParameter("wso2tracer.trace.persister.impl");
        MessagePayload messagePayload = new MessagePayload();
        TracePersister tracePersisterImpl = this.getTracePersister(tracePersisterParam);
        if (tracePersisterImpl != null) {
            String[] respArray = tracePersisterImpl.getMessages(serviceId, operationName, messageSequence);
            if (respArray[0] != null) {
                messagePayload.setRequest(respArray[0]);
            }
            if (respArray[1] != null) {
                messagePayload.setResponse(respArray[1]);
            }
        } else {
            String message = "Tracer service encountered an error ";
            log.error((Object)message);
            throw new RuntimeException(message);
        }
        return messagePayload;
    }

    private TracePersister getTracePersister(Parameter tracePersisterParam) throws AxisFault {
        TracePersister tracePersister = null;
        if (tracePersisterParam != null) {
            Object tracePersisterImplObj = tracePersisterParam.getValue();
            if (tracePersisterImplObj instanceof TracePersister) {
                tracePersister = (TracePersister)tracePersisterImplObj;
            } else if (tracePersisterImplObj instanceof String) {
                try {
                    tracePersister = (TracePersister)Loader.loadClass((String)((String)tracePersisterImplObj).trim()).newInstance();
                }
                catch (Exception e) {
                    String message = "Cannot instatiate TracePersister ";
                    log.error((Object)message, (Throwable)e);
                    throw new RuntimeException(message, e);
                }
            }
        } else {
            throw new AxisFault("wso2tracer.trace.persister.impl parameter not defined in axis2.xml");
        }
        return tracePersister;
    }
}

