/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.tracer.module.handler;

import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.wso2.tracer.module.TraceFilter;
import org.wso2.tracer.module.TracePersister;
import org.wso2.tracer.service.MessageInfo;
import org.wso2.utils.CircularBuffer;

public class TracingHandler
extends AbstractHandler {
    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        AxisService axisService = msgContext.getAxisService();
        if (axisService == null) {
            return Handler.InvocationResponse.CONTINUE;
        }
        if (axisService.isClientSide()) {
            return Handler.InvocationResponse.CONTINUE;
        }
        ConfigurationContext configCtx = msgContext.getConfigurationContext();
        TraceFilter traceFilter = (TraceFilter)this.getParameter("wso2tracer.trace.filter.impl").getValue();
        if (traceFilter.isFilteredOut(msgContext)) {
            return Handler.InvocationResponse.CONTINUE;
        }
        if (msgContext.getAxisOperation() != null && msgContext.getAxisOperation().getName() != null) {
            String operationName = msgContext.getAxisOperation().getName().getLocalPart();
            String serviceName = axisService.getName();
            long msgSeq = this.storeMessage(operationName, serviceName, msgContext);
            if (msgContext.getFLOW() == 1) {
                CircularBuffer msgSeqBuff = (CircularBuffer)configCtx.getProperty("wso2tracer.msg.seq.buff");
                if (msgSeqBuff == null) {
                    msgSeqBuff = new CircularBuffer(250);
                    configCtx.setProperty("wso2tracer.msg.seq.buff", (Object)msgSeqBuff);
                }
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTime(new Date());
                MessageInfo messageInfo = new MessageInfo();
                messageInfo.setMessageSequence(msgSeq);
                messageInfo.setOperationName(operationName);
                messageInfo.setServiceId(serviceName);
                messageInfo.setTimestamp(cal);
                msgSeqBuff.append((Object)messageInfo);
            }
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    private long storeMessage(String operationName, String serviceName, MessageContext msgCtxt) {
        TracePersister tracePersister = (TracePersister)this.getParameter("wso2tracer.trace.persister.impl").getValue();
        tracePersister.setMsgContext(msgCtxt);
        return tracePersister.saveMessage(operationName, serviceName, msgCtxt.getFLOW(), msgCtxt.getEnvelope());
    }
}

