/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.tracer.module;

import java.util.HashMap;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.context.MessageContext;
import org.wso2.tracer.TracerUtils;
import org.wso2.tracer.module.TraceMessage;
import org.wso2.tracer.module.TracePersister;
import org.wso2.utils.CircularBuffer;

public class MemoryBasedTracePersister
implements TracePersister {
    private static final String TRACING_MAP = "local_wso2tracer.map";
    private static final String REQUEST_NUMBER = "local_wso2tracer.request.number";
    private MessageContext msgContext;
    private CircularBuffer msgBuffer = new CircularBuffer(250);
    private String tracingStatus;

    public void setMsgContext(MessageContext msgContext) {
        this.msgContext = msgContext;
    }

    public synchronized long saveMessage(String operationName, String serviceName, int messageFlow, SOAPEnvelope env) {
        long msgSequence = this.getMessageSequence(serviceName, operationName);
        TraceMessage message = new TraceMessage(operationName, serviceName, messageFlow, msgSequence, env);
        this.msgBuffer.append((Object)message);
        return msgSequence;
    }

    public void saveTraceStatus(String onOff) {
        this.tracingStatus = onOff;
    }

    public boolean isTracingEnabled() {
        return this.tracingStatus != null && this.tracingStatus.equalsIgnoreCase("ON");
    }

    public synchronized String[] getMessages(String serviceId, String operationName, long messageSequence) {
        String[] responses = new String[2];
        Object[] objects = this.msgBuffer.getObjects(250);
        for (int i = 0; i < objects.length; ++i) {
            TraceMessage msg = (TraceMessage)objects[i];
            if (!msg.getOperationName().equals(operationName) || !msg.getServiceName().equals(serviceId) || msg.getMsgSequence() != messageSequence) continue;
            int messageFlow = msg.getMessageFlow();
            if (messageFlow == 1 || messageFlow == 3) {
                responses[0] = TracerUtils.getPrettyString(msg.getSoapEnvelope(), this.msgContext);
                continue;
            }
            if (messageFlow != 2 && messageFlow != 4) continue;
            responses[1] = TracerUtils.getPrettyString(msg.getSoapEnvelope(), this.msgContext);
        }
        return responses;
    }

    private long getMessageSequence(String serviceName, String operationName) {
        long msgSequence = 1L;
        Object requestNumber = this.msgContext.getOperationContext().getProperty(REQUEST_NUMBER);
        if (requestNumber != null && requestNumber instanceof Long) {
            msgSequence = ((Long)requestNumber).intValue();
        } else {
            String key;
            Object counterInt;
            HashMap<String, Long> monitoringHandlerMap = (HashMap<String, Long>)this.msgContext.getConfigurationContext().getProperty(TRACING_MAP);
            if (monitoringHandlerMap == null) {
                monitoringHandlerMap = new HashMap<String, Long>();
                this.msgContext.getConfigurationContext().setProperty(TRACING_MAP, monitoringHandlerMap);
            }
            if ((counterInt = monitoringHandlerMap.get(key = serviceName + "." + operationName)) == null) {
                msgSequence = 0L;
            } else if (counterInt instanceof Long) {
                msgSequence = ((Long)counterInt).intValue() + 1;
            }
            monitoringHandlerMap.put(key, new Long(msgSequence));
            this.msgContext.getOperationContext().setProperty(REQUEST_NUMBER, (Object)new Long(msgSequence));
        }
        return msgSequence;
    }
}

