/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.clustering.configuration.commands;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.engine.AxisConfiguration;
import org.wso2.wsas.clustering.configuration.commands.AbstractConfigurationCommand;

public class UnloadServiceGroupsCommand
extends AbstractConfigurationCommand {
    private List axisServiceGroups = new ArrayList();
    private String[] serviceGroupNames;

    public synchronized void process(ConfigurationContext confiCtx) throws Exception {
        log.info((Object)"Going to unload service groups...");
        this.axisServiceGroups.clear();
        AxisConfiguration axisConfig = confiCtx.getAxisConfiguration();
        for (int i = 0; i < this.serviceGroupNames.length; ++i) {
            String sgName = this.serviceGroupNames[i];
            AxisServiceGroup serviceGroup = axisConfig.getServiceGroup(sgName);
            if (serviceGroup == null) {
                String msg = "Service group " + sgName + " does not exist";
                log.info((Object)msg);
                throw new Exception(msg);
            }
            log.info((Object)("Going to unload service group " + sgName));
            this.axisServiceGroups.add(serviceGroup);
        }
    }

    public synchronized void prepare(ConfigurationContext configContext) {
        Iterator iterator = this.axisServiceGroups.iterator();
        while (iterator.hasNext()) {
            AxisServiceGroup axisSG = (AxisServiceGroup)iterator.next();
            this.addBlockAllRequestsParameter(axisSG);
        }
    }

    public synchronized void commit(ConfigurationContext configContext) throws Exception {
        log.info((Object)("Committing " + (Object)((Object)this) + "..."));
        Iterator sgIter = this.axisServiceGroups.iterator();
        while (sgIter.hasNext()) {
            AxisServiceGroup serviceGroup = (AxisServiceGroup)sgIter.next();
            configContext.getAxisConfiguration().removeServiceGroup(serviceGroup.getServiceGroupName());
        }
        log.info((Object)("Committed " + (Object)((Object)this)));
    }

    public synchronized void rollback(ConfigurationContext configContext) throws Exception {
        log.info((Object)("Rolling back " + (Object)((Object)this) + "..."));
        this.axisServiceGroups.clear();
        log.info((Object)("Rolled back " + (Object)((Object)this)));
    }

    public synchronized void setServiceGroupNames(String[] serviceGroupNames) {
        this.serviceGroupNames = serviceGroupNames;
    }

    public String toString() {
        return "UNLOAD_SERVICE_GROUPS_EVENT";
    }

    public int getCommandType() {
        return 2;
    }
}

