/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.clustering.configuration.commands;

import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.engine.AxisConfigurator;
import org.wso2.utils.ServerConfiguration;
import org.wso2.utils.ServerConfigurator;
import org.wso2.utils.WSO2ConfigurationContextFactory;
import org.wso2.wsas.ServerManagement;
import org.wso2.wsas.clustering.configuration.commands.AbstractConfigurationCommand;
import org.wso2.wsas.util.Controllable;

public class ReloadConfigurationCommand
extends AbstractConfigurationCommand {
    private ConfigurationContext newConfigContext;

    public void process(ConfigurationContext configCtx) throws Exception {
        log.info((Object)"Loading new configuration...");
        ServerConfiguration config = ServerConfiguration.getInstance();
        String repoLocation = config.getFirstProperty("Axis2Config.RepositoryLocation");
        ServerConfigurator.getInstance().init(repoLocation, System.getProperty("web.location"));
        this.newConfigContext = WSO2ConfigurationContextFactory.createNewConfigurationContext((AxisConfigurator)ServerConfigurator.getInstance());
        log.info((Object)"New configuration successfully loaded and cached. Waiting for prepare request...");
    }

    public void prepare(ConfigurationContext configCtx) {
        try {
            new ServerManagement().waitForRequestCompletion();
        }
        catch (Exception e) {
            log.error((Object)"Could not wait for request completion", (Throwable)e);
        }
        configCtx.setProperty("local_wso2wsas.block.requests", (Object)Boolean.TRUE);
    }

    public void commit(ConfigurationContext configContext) throws Exception {
        Controllable controllable = (Controllable)configContext.getProperty("local_WSO2_WSAS");
        configContext.getServiceGroupContexts().clear();
        controllable.setConfigurationContext(this.newConfigContext);
    }

    public void rollback(ConfigurationContext configContext) throws Exception {
    }

    public String toString() {
        return "LOAD_CONFIGURATION_EVENT";
    }

    public int getCommandType() {
        return 0;
    }
}

