/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.clustering.configuration.commands;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.activation.DataHandler;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.utils.ServerConfiguration;
import org.wso2.wsas.clustering.configuration.commands.AbstractConfigurationCommand;
import org.wso2.wsas.util.WsasUtils;

public class LoadServiceGroupsCommand
extends AbstractConfigurationCommand {
    private static Log log = LogFactory.getLog((Class)LoadServiceGroupsCommand.class);
    private List axisServiceGroups = new ArrayList();
    private String[] serviceGroupNames;
    private static final Random RANDOM = new Random();

    public synchronized void process(ConfigurationContext configCtx) throws Exception {
        log.info((Object)"Going to load service groups...");
        this.axisServiceGroups.clear();
        AxisConfiguration axisConfig = configCtx.getAxisConfiguration();
        ServerConfiguration serverConfig = ServerConfiguration.getInstance();
        String axis2Repo = serverConfig.getFirstProperty("Axis2Config.RepositoryLocation");
        for (int i = 0; i < this.serviceGroupNames.length; ++i) {
            File serviceArchive;
            String sgName = this.serviceGroupNames[i];
            if (!sgName.endsWith(".aar")) {
                sgName = sgName + ".aar";
            }
            log.info((Object)("Going to load service group - " + sgName + " ..."));
            AxisServiceGroup serviceGroup = axisConfig.getServiceGroup(sgName);
            if (serviceGroup == null) {
                if (WsasUtils.isURL((String)axis2Repo)) {
                    DataHandler dh = new DataHandler(new URL(axis2Repo + "services/" + sgName));
                    String tempDir = serverConfig.getFirstProperty("WorkDirectory") + File.separator + ((double)System.currentTimeMillis() + RANDOM.nextDouble());
                    new File(tempDir).mkdirs();
                    serviceArchive = new File(tempDir + File.separator + sgName);
                    FileOutputStream out = new FileOutputStream(serviceArchive);
                    dh.writeTo((OutputStream)out);
                    out.close();
                } else {
                    serviceArchive = new File(axis2Repo + File.separator + "services" + File.separator + sgName);
                }
            } else {
                String msg = "Service group " + sgName + " already exists!";
                log.error((Object)msg);
                throw new Exception(msg);
            }
            AxisServiceGroup asGroup = DeploymentEngine.loadServiceGroup((File)serviceArchive, (ConfigurationContext)configCtx);
            this.axisServiceGroups.add(asGroup);
        }
    }

    public synchronized void prepare(ConfigurationContext configContext) {
        Iterator iterator = this.axisServiceGroups.iterator();
        while (iterator.hasNext()) {
            AxisServiceGroup axisSG = (AxisServiceGroup)iterator.next();
            this.addBlockAllRequestsParameter(axisSG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void commit(ConfigurationContext configContext) throws Exception {
        log.info((Object)("Committing " + (Object)((Object)this) + "..."));
        try {
            Iterator iter = this.axisServiceGroups.iterator();
            while (iter.hasNext()) {
                AxisServiceGroup serviceGroup = (AxisServiceGroup)iter.next();
                configContext.getAxisConfiguration().addServiceGroup(serviceGroup);
                this.removeBlockAllRequestsParameter(serviceGroup);
            }
        }
        finally {
            this.axisServiceGroups.clear();
        }
        log.info((Object)("Committed " + (Object)((Object)this)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void rollback(ConfigurationContext configContext) throws Exception {
        log.info((Object)("Rolling back " + (Object)((Object)this) + "..."));
        AxisConfiguration axisConfig = configContext.getAxisConfiguration();
        try {
            for (int i = 0; i < this.axisServiceGroups.size(); ++i) {
                AxisServiceGroup serviceGroup = (AxisServiceGroup)this.axisServiceGroups.get(i);
                Iterator serviceIter = serviceGroup.getServices();
                while (serviceIter.hasNext()) {
                    AxisService service = (AxisService)serviceIter.next();
                    if (axisConfig.getService(service.getName()) == null) continue;
                    axisConfig.removeService(service.getName());
                }
                String serviceGroupName = serviceGroup.getServiceGroupName();
                if (axisConfig.getServiceGroup(serviceGroupName) == null) continue;
                axisConfig.removeServiceGroup(serviceGroupName);
            }
        }
        finally {
            this.axisServiceGroups.clear();
        }
        log.info((Object)("Rolled back " + (Object)((Object)this) + "..."));
    }

    public String toString() {
        return "LOAD_SERVICE_GROUPS_EVENT";
    }

    public synchronized void setServiceGroupNames(String[] serviceGroupNames) {
        this.serviceGroupNames = serviceGroupNames;
    }

    public int getCommandType() {
        return 1;
    }
}

