/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.clustering.configuration.commands;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.PolicyInclude;
import org.apache.neethi.Policy;
import org.apache.neethi.util.PolicyComparator;
import org.wso2.wsas.clustering.configuration.commands.AbstractConfigurationCommand;
import org.wso2.wsas.util.PolicyUtil;

public class ApplyServicePolicyCommand
extends AbstractConfigurationCommand {
    private ServicePolicy servicePolicy;
    private String policy;
    private String serviceName;

    public void process(ConfigurationContext confiCtx) throws Exception {
        log.info((Object)"Applying policy to service ...");
        this.servicePolicy = null;
        ByteArrayInputStream bais = new ByteArrayInputStream(this.policy.getBytes());
        AxisService axisService = confiCtx.getAxisConfiguration().getService(this.serviceName);
        if (axisService == null) {
            String msg = "Service " + this.serviceName + " does not exist";
            log.info((Object)msg);
            throw new Exception(msg);
        }
        OMElement policyElement = new StAXOMBuilder((InputStream)bais).getDocumentElement();
        policyElement.build();
        Policy policy = PolicyUtil.getPolicyFromOMElement((OMElement)policyElement);
        this.servicePolicy = new ServicePolicy(axisService, policy);
    }

    public void prepare(ConfigurationContext configContext) {
        this.addBlockAllRequestsParameter(this.servicePolicy.getAxisService());
    }

    public void commit(ConfigurationContext configContext) throws Exception {
        AxisService axisService = this.servicePolicy.getAxisService();
        Policy newPolicy = this.servicePolicy.getPolicy();
        PolicyInclude policyInclude = axisService.getPolicyInclude();
        boolean isPolicyFound = false;
        Iterator iter = policyInclude.getPolicyElements().iterator();
        while (iter.hasNext()) {
            Policy policy;
            Object obj = iter.next();
            if (!(obj instanceof Policy) || !PolicyComparator.compare((Policy)(policy = (Policy)obj), (Policy)newPolicy)) continue;
            newPolicy.setId(policy.getId());
            policyInclude.updatePolicy(newPolicy);
            isPolicyFound = true;
            break;
        }
        if (!isPolicyFound) {
            policyInclude.addPolicyElement(3, newPolicy);
        }
        this.removeBlockAllRequestsParameter(axisService);
    }

    public void rollback(ConfigurationContext configContext) throws Exception {
    }

    public String toString() {
        return "APPLY_SERVICE_POLICY_EVENT";
    }

    public int getCommandType() {
        return 3;
    }

    public void setPolicy(String policy) {
        this.policy = policy;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    private static class ServicePolicy {
        private AxisService axisService;
        private Policy policy;

        public ServicePolicy(AxisService axisService, Policy policy) {
            this.axisService = axisService;
            this.policy = policy;
        }

        public AxisService getAxisService() {
            return this.axisService;
        }

        public Policy getPolicy() {
            return this.policy;
        }
    }
}

