/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.clustering.configuration;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.axis2.AxisFault;
import org.apache.axis2.clustering.configuration.ConfigurationClusteringCommand;
import org.apache.axis2.clustering.configuration.ConfigurationManagerListener;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WSASConfigurationManagerListener
implements ConfigurationManagerListener {
    private static Log log = LogFactory.getLog((Class)WSASConfigurationManagerListener.class);
    private ConfigurationContext configurationContext;
    private List pendingCommits = new Vector();
    private boolean isProcessing;
    private boolean isPreparing;
    private boolean isCompleteReceived;
    private static final int DEFAULT_COMMIT_TIMEOUT = 50000;
    private boolean isCommitTimerStarted;
    private Thread commitTimer;

    public void serviceGroupsLoaded(ConfigurationClusteringCommand cmd) {
        this.processCommand(cmd);
    }

    public void serviceGroupsUnloaded(ConfigurationClusteringCommand cmd) {
        this.processCommand(cmd);
    }

    public void policyApplied(ConfigurationClusteringCommand cmd) {
        this.processCommand(cmd);
    }

    public void configurationReloaded(ConfigurationClusteringCommand cmd) {
        this.processCommand(cmd);
    }

    private void processCommand(ConfigurationClusteringCommand cmd) {
        this.isProcessing = true;
        try {
            this.pendingCommits.add(cmd);
            this.startCommitTimer(System.currentTimeMillis());
            cmd.process(this.configurationContext);
        }
        catch (Throwable e) {
            this.notifyFailure(e);
        }
        this.isProcessing = false;
    }

    public void prepareCalled() {
        this.isPreparing = true;
        Thread prepareWaiter = new Thread("PrepareWaiter"){

            public void run() {
                while (WSASConfigurationManagerListener.this.isProcessing) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException ignored) {
                        ignored.printStackTrace();
                    }
                }
                if (WSASConfigurationManagerListener.this.pendingCommits.isEmpty()) {
                    log.warn((Object)"Prepare command received but no pending commits found.");
                    WSASConfigurationManagerListener.this.notifyFailureToNodeManager();
                    return;
                }
                log.info((Object)"Preparing to commit...");
                Iterator iter = WSASConfigurationManagerListener.this.pendingCommits.iterator();
                while (iter.hasNext()) {
                    ((ConfigurationClusteringCommand)iter.next()).prepare(WSASConfigurationManagerListener.this.configurationContext);
                }
                WSASConfigurationManagerListener.this.isPreparing = false;
            }
        };
        prepareWaiter.start();
    }

    private void removeCommitInProgressParam() {
        try {
            AxisService axisService = this.configurationContext.getAxisConfiguration().getService("Axis2NodeManager");
            Parameter parameter = axisService.getParameter("nodemanager.commit.in.progress");
            if (parameter != null) {
                axisService.removeParameter(parameter);
            }
        }
        catch (AxisFault e) {
            log.error((Object)"Error occurred while removing commit in progress parameter", (Throwable)e);
        }
    }

    private void startCommitTimer(final long startedTime) {
        if (this.isCommitTimerStarted) {
            return;
        }
        this.commitTimer = new Thread("CommitTimer"){

            public void run() {
                WSASConfigurationManagerListener.this.isCommitTimerStarted = true;
                AxisConfiguration axisConfig = WSASConfigurationManagerListener.this.configurationContext.getAxisConfiguration();
                Parameter parameter = axisConfig.getClusterManager().getConfigurationManager().getParameter("CommitTimeout");
                long timeOut = 50000L;
                if (parameter != null) {
                    timeOut = Long.parseLong((String)parameter.getValue());
                }
                while (!WSASConfigurationManagerListener.this.isCompleteReceived) {
                    if (startedTime != 0L && System.currentTimeMillis() - startedTime > timeOut) {
                        WSASConfigurationManagerListener.this.pendingCommits.clear();
                        WSASConfigurationManagerListener.this.configurationContext.removePropertyNonReplicable("local_wso2wsas.block.requests");
                        log.info((Object)("Commit/Rollback message not received within " + timeOut + " ms. Rolling back all changes & resuming operations."));
                        WSASConfigurationManagerListener.this.rollback();
                        break;
                    }
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException ignored) {
                        // empty catch block
                        break;
                    }
                }
                WSASConfigurationManagerListener.this.isCommitTimerStarted = false;
                WSASConfigurationManagerListener.this.isCompleteReceived = false;
            }
        };
        this.commitTimer.start();
    }

    public void rollbackCalled() {
        this.notifyFailureToNodeManager();
        this.isCompleteReceived = true;
        this.commitTimer.interrupt();
        log.info((Object)"Rolling back configuration changes...");
        try {
            this.rollback();
        }
        catch (Exception e) {
            log.error((Object)"Exception occurred while rolling back configuration changes", (Throwable)e);
        }
        log.info((Object)"Configuration changes rolled back successfully.");
    }

    public void commitCalled() {
        this.commitTimer.interrupt();
        this.isCompleteReceived = true;
        Thread commitThread = new Thread(){

            public void run() {
                if (WSASConfigurationManagerListener.this.pendingCommits.isEmpty()) {
                    log.warn((Object)"Commit command received but no pending commits found.");
                    WSASConfigurationManagerListener.this.notifyFailureToNodeManager();
                    WSASConfigurationManagerListener.this.removeCommitInProgressParam();
                    return;
                }
                while (WSASConfigurationManagerListener.this.isPreparing) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException ignored) {
                        ignored.printStackTrace();
                    }
                }
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ignored) {
                    ignored.printStackTrace();
                }
                log.info((Object)"Committing configuration changes...");
                Iterator iter = WSASConfigurationManagerListener.this.pendingCommits.iterator();
                while (iter.hasNext()) {
                    ConfigurationClusteringCommand cmd = (ConfigurationClusteringCommand)iter.next();
                    try {
                        cmd.commit(WSASConfigurationManagerListener.this.configurationContext);
                        log.info((Object)"Commit successful");
                    }
                    catch (Exception e) {
                        log.info((Object)"Commit failed");
                        WSASConfigurationManagerListener.this.notifyFailure(new Exception("Could not commit " + cmd));
                    }
                }
                WSASConfigurationManagerListener.this.configurationContext.removePropertyNonReplicable("local_wso2wsas.block.requests");
                WSASConfigurationManagerListener.this.pendingCommits.clear();
                WSASConfigurationManagerListener.this.removeCommitInProgressParam();
            }
        };
        commitThread.start();
    }

    public void handleException(Throwable throwable) {
        log.info((Object)"Handling exception...");
        this.notifyFailureToNodeManager();
        this.commitTimer.interrupt();
        this.isCompleteReceived = true;
        this.rollback();
    }

    public void setConfigurationContext(ConfigurationContext configurationContext) {
        this.configurationContext = configurationContext;
    }

    private void rollback() {
        Iterator iter = this.pendingCommits.iterator();
        while (iter.hasNext()) {
            ConfigurationClusteringCommand cmd = (ConfigurationClusteringCommand)iter.next();
            try {
                cmd.rollback(this.configurationContext);
            }
            catch (Exception e) {
                log.error((Object)("Error occurred while rolling back command " + cmd), (Throwable)e);
            }
        }
        this.pendingCommits.clear();
        this.removeCommitInProgressParam();
        this.isCompleteReceived = false;
        this.isPreparing = false;
        this.isProcessing = false;
        this.configurationContext.removePropertyNonReplicable("local_wso2wsas.block.requests");
        iter = this.configurationContext.getAxisConfiguration().getServiceGroups();
        while (iter.hasNext()) {
            AxisServiceGroup serviceGroup = (AxisServiceGroup)iter.next();
            Parameter parameter = serviceGroup.getParameter("local_wso2wsas.block.requests");
            if (parameter == null) continue;
            try {
                serviceGroup.removeParameter(parameter);
            }
            catch (AxisFault e) {
                log.error((Object)("Could not remove the local_wso2wsas.block.requests parameter from the " + serviceGroup.getServiceGroupName() + " service group."));
            }
        }
    }

    private void notifyFailure(Throwable e) {
        try {
            this.notifyFailureToNodeManager();
            this.configurationContext.getAxisConfiguration().getClusterManager().getConfigurationManager().exceptionOccurred(e);
        }
        catch (Exception e2) {
            log.error((Object)"Error occurred while notifying failure to cluster or local NodeManager", (Throwable)e2);
        }
    }

    private void notifyFailureToNodeManager() {
        try {
            AxisService axisService = this.configurationContext.getAxisConfiguration().getService("Axis2NodeManager");
            if (axisService != null) {
                axisService.addParameter(new Parameter("nodemanager.operation.failed", (Object)"true"));
            }
        }
        catch (Exception e2) {
            log.error((Object)"Error occurred while notifying failure to local node manager", (Throwable)e2);
        }
    }
}

