/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.clustering;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.wso2.wsas.clustering.WSO2WSASNodeManagerStub;

public class NodeManagerClient {
    private WSO2WSASNodeManagerStub stub;

    public NodeManagerClient(String nodeManagerEPR) throws AxisFault {
        this.stub = new WSO2WSASNodeManagerStub(nodeManagerEPR);
        this.stub._getServiceClient().getOptions().setManageSession(true);
        this.setSecurityProperties();
    }

    private boolean reloadConfiguration() throws Exception {
        System.out.println("Going to reload configuration...");
        return this.stub.reloadConfiguration().get_return();
    }

    private boolean unloadServiceGroups(String[] serviceGroupNames) throws Exception {
        for (int i = 0; i < serviceGroupNames.length; ++i) {
            System.out.println("Unloading service group: " + serviceGroupNames[i]);
        }
        WSO2WSASNodeManagerStub.UnloadServiceGroups req = new WSO2WSASNodeManagerStub.UnloadServiceGroups();
        req.setServiceGroupNames(serviceGroupNames);
        WSO2WSASNodeManagerStub.UnloadServiceGroupsResponse resp = this.stub.unloadServiceGroups(req);
        return resp.get_return();
    }

    private boolean loadServiceGroups(String[] serviceGroupNames) throws Exception {
        for (int i = 0; i < serviceGroupNames.length; ++i) {
            System.out.println("Loading service group: " + serviceGroupNames[i]);
        }
        WSO2WSASNodeManagerStub.LoadServiceGroups req = new WSO2WSASNodeManagerStub.LoadServiceGroups();
        req.setServiceGroupNames(serviceGroupNames);
        WSO2WSASNodeManagerStub.LoadServiceGroupsResponse resp = this.stub.loadServiceGroups(req);
        return resp.get_return();
    }

    private boolean applyServicePolicy(String serviceName, String policyFile) throws Exception {
        System.out.println("Applying policy to service: " + serviceName);
        WSO2WSASNodeManagerStub.ApplyPolicy req = new WSO2WSASNodeManagerStub.ApplyPolicy();
        req.setServiceName(serviceName);
        StAXOMBuilder builder = new StAXOMBuilder((InputStream)new FileInputStream(policyFile));
        req.setPolicy(builder.getDocumentElement());
        WSO2WSASNodeManagerStub.ApplyPolicyResponse resp = this.stub.applyPolicy(req);
        return resp.get_return();
    }

    private boolean commit() throws Exception {
        System.out.println("Committing...");
        if (this.stub.prepare().get_return()) {
            return this.stub.commit().get_return();
        }
        return false;
    }

    private boolean login(String username, String password) throws Exception {
        System.out.println("Logging in...");
        WSO2WSASNodeManagerStub.Login req = new WSO2WSASNodeManagerStub.Login();
        req.setUsername(username);
        req.setPassword(password);
        return this.stub.login(req).get_return();
    }

    public static void main(String[] args) {
        try {
            String username = NodeManagerClient.getParam("--username", args);
            String password = NodeManagerClient.getParam("--password", args);
            String epr = NodeManagerClient.getParam("--epr", args);
            NodeManagerClient client = new NodeManagerClient(epr);
            String operation = NodeManagerClient.getParam("--operation", args);
            if (!client.login(username, password)) {
                System.err.println("Login failed. Please verify the admin username & password");
            }
            boolean isOperationSuccessful = false;
            if (operation.equals("reloadconfig")) {
                isOperationSuccessful = client.reloadConfiguration();
            } else if (operation.equals("loadsgs")) {
                String[] serviceGroups = NodeManagerClient.getServiceGroups(NodeManagerClient.getParam("--service-groups", args));
                isOperationSuccessful = client.loadServiceGroups(serviceGroups);
            } else if (operation.equals("unloadsgs")) {
                String[] serviceGroups = NodeManagerClient.getServiceGroups(NodeManagerClient.getParam("--service-groups", args));
                isOperationSuccessful = client.unloadServiceGroups(serviceGroups);
            } else if (operation.equals("applypolicy")) {
                String serviceName = NodeManagerClient.getParam("--service", args);
                String policyFile = NodeManagerClient.getParam("--policy-file", args);
                isOperationSuccessful = client.applyServicePolicy(serviceName, policyFile);
            } else if (operation.equals("commit")) {
                isOperationSuccessful = client.commit();
            } else {
                NodeManagerClient.printUsage();
            }
            if (isOperationSuccessful) {
                System.exit(0);
            } else {
                System.exit(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static String[] getServiceGroups(String serviceGroups) {
        StringTokenizer tokenizer = new StringTokenizer(serviceGroups, ",");
        ArrayList<String> list = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken().trim());
        }
        return list.toArray(new String[list.size()]);
    }

    private static void printUsage() {
        System.out.println("usage: admin --username <username> --password <password> --epr <epr> --operation <reloadconfig|loadsgs|unloadsgs|applypolicy|commit> [options]");
        System.out.println("options: --service-groups <ServiceGroupName1,ServiceGroupName2,...,ServiceGroupNameN>");
    }

    private static String getParam(String param, String[] args) {
        if (param == null || "".equals(param)) {
            return null;
        }
        for (int i = 0; i < args.length; i += 2) {
            String arg = args[i];
            if (!param.equalsIgnoreCase(arg) || args.length < i + 1) continue;
            if (args.length == i + 1) {
                System.err.println("Invalid value specified for option " + arg);
                NodeManagerClient.printUsage();
                System.exit(1);
            }
            return args[i + 1].trim();
        }
        NodeManagerClient.printUsage();
        System.exit(1);
        return null;
    }

    private void setSecurityProperties() {
        String tsPassword;
        String trustStore;
        String ksType;
        String ksPassword = System.getProperty("javax.net.ssl.keyStorePassword");
        if (ksPassword == null) {
            System.setProperty("javax.net.ssl.keyStorePassword", "wso2wsas");
        }
        if ((ksType = System.getProperty("javax.net.ssl.keyStoreType")) == null) {
            System.setProperty("javax.net.ssl.keyStoreType", "JKS");
        }
        if ((trustStore = System.getProperty("javax.net.ssl.trustStore")) == null || trustStore.trim().length() == 0) {
            System.setProperty("javax.net.ssl.trustStore", ".." + File.separator + "conf" + File.separator + "client-truststore.jks");
        }
        if ((tsPassword = System.getProperty("javax.net.ssl.trustStorePassword")) == null) {
            System.setProperty("javax.net.ssl.trustStorePassword", "wso2wsas");
        }
    }
}

