/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.clustering;

import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.clustering.ClusterManager;
import org.apache.axis2.clustering.configuration.ConfigurationManager;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.wsas.admin.service.GlobalAdmin;

public class NodeManager {
    private Log log = LogFactory.getLog((Class)NodeManager.class);
    private static final String CONFIG_MANAGER_NULL = "ConfigurationManager is null. Please properly set the 'cluster' element in the axis2.xml file";
    private static final String CLUSTER_MANAGER_NULL = "ClusterManager is null. Please properly set the 'cluster' element in the axis2.xml file";
    public static final String OPERATION_FAILED = "nodemanager.operation.failed";
    public static final String COMMIT_IN_PROGRESS = "nodemanager.commit.in.progress";
    private static final int DEFAULT_NOTIFICATION_WAIT_TIME = 2000;

    public boolean unloadServiceGroups(String[] serviceGroupNames) throws AxisFault {
        this.init();
        ConfigurationManager configMan = this.getConfigurationManager();
        if (configMan == null) {
            throw new AxisFault(CONFIG_MANAGER_NULL);
        }
        configMan.unloadServiceGroups(serviceGroupNames);
        return this.isOperationSuccessful();
    }

    public boolean loadServiceGroups(String[] serviceGroupNames) throws AxisFault {
        this.init();
        ConfigurationManager configMan = this.getConfigurationManager();
        if (configMan == null) {
            throw new AxisFault(CONFIG_MANAGER_NULL);
        }
        configMan.loadServiceGroups(serviceGroupNames);
        return this.isOperationSuccessful();
    }

    public boolean applyPolicy(String serviceName, OMElement policy) throws AxisFault {
        this.init();
        ConfigurationManager configMan = this.getConfigurationManager();
        if (configMan == null) {
            throw new AxisFault(CONFIG_MANAGER_NULL);
        }
        configMan.applyPolicy(serviceName, policy.getFirstElement().toString());
        return this.isOperationSuccessful();
    }

    public boolean reloadConfiguration() throws AxisFault {
        this.init();
        ConfigurationManager configMan = this.getConfigurationManager();
        if (configMan == null) {
            throw new AxisFault(CONFIG_MANAGER_NULL);
        }
        configMan.reloadConfiguration();
        return this.isOperationSuccessful();
    }

    public boolean prepare() throws AxisFault {
        return this.isPrepareSuccessful(this.getConfigurationManager());
    }

    public boolean commit() throws AxisFault {
        this.init();
        ConfigurationManager configMan = this.getConfigurationManager();
        if (configMan == null) {
            throw new AxisFault(CONFIG_MANAGER_NULL);
        }
        return this.isCommitSuccessful(configMan);
    }

    public boolean login(String username, String password) throws AxisFault {
        return new GlobalAdmin().login(username, password);
    }

    private ConfigurationManager getConfigurationManager() {
        ConfigurationContext rootContext = MessageContext.getCurrentMessageContext().getRootContext();
        if (rootContext != null) {
            ClusterManager clusterManager = rootContext.getAxisConfiguration().getClusterManager();
            if (clusterManager != null) {
                ConfigurationManager configMan = clusterManager.getConfigurationManager();
                if (configMan != null) {
                    return configMan;
                }
            } else {
                this.log.warn((Object)CLUSTER_MANAGER_NULL);
            }
        }
        return null;
    }

    private boolean isCommitSuccessful(ConfigurationManager configMan) throws AxisFault {
        boolean result;
        MessageContext msgCtx = MessageContext.getCurrentMessageContext();
        AxisService axisService = msgCtx.getAxisService();
        axisService.addParameter(new Parameter(COMMIT_IN_PROGRESS, (Object)"true"));
        Parameter opFailed = axisService.getParameter(OPERATION_FAILED);
        if (opFailed == null) {
            configMan.commit();
            while (axisService.getParameter(COMMIT_IN_PROGRESS) != null) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            opFailed = axisService.getParameter(OPERATION_FAILED);
            result = opFailed == null;
        } else {
            result = false;
        }
        if (opFailed != null) {
            axisService.removeParameter(opFailed);
        }
        return result;
    }

    private void init() throws AxisFault {
        MessageContext msgCtx = MessageContext.getCurrentMessageContext();
        AxisService axisService = msgCtx.getAxisService();
        Parameter opFailed = axisService.getParameter(OPERATION_FAILED);
        if (opFailed != null) {
            axisService.removeParameter(opFailed);
        }
    }

    private boolean isOperationSuccessful() throws AxisFault {
        boolean result;
        this.delay();
        MessageContext msgCtx = MessageContext.getCurrentMessageContext();
        AxisService axisService = msgCtx.getAxisService();
        Parameter opFailed = axisService.getParameter(OPERATION_FAILED);
        if (opFailed == null) {
            this.delay();
            opFailed = axisService.getParameter(OPERATION_FAILED);
            result = opFailed == null;
        } else {
            result = false;
        }
        if (opFailed != null) {
            axisService.removeParameter(opFailed);
        }
        return result;
    }

    private boolean isPrepareSuccessful(ConfigurationManager configMan) throws AxisFault {
        boolean result;
        this.delay();
        MessageContext msgCtx = MessageContext.getCurrentMessageContext();
        AxisService axisService = msgCtx.getAxisService();
        Parameter opFailed = axisService.getParameter(OPERATION_FAILED);
        if (opFailed == null) {
            configMan.prepare();
            this.delay();
            opFailed = axisService.getParameter(OPERATION_FAILED);
            result = opFailed == null;
        } else {
            result = false;
        }
        if (opFailed != null) {
            axisService.removeParameter(opFailed);
        }
        return result;
    }

    private void delay() {
        try {
            AxisConfiguration axisConfig = MessageContext.getCurrentMessageContext().getRootContext().getAxisConfiguration();
            Parameter parameter = axisConfig.getClusterManager().getConfigurationManager().getParameter("NotificationWaitTime");
            long delay = 2000L;
            if (parameter != null) {
                delay = Long.parseLong((String)parameter.getValue());
            }
            Thread.sleep(delay);
        }
        catch (InterruptedException e) {
            this.log.error((Object)"Thread was interrupted", (Throwable)e);
        }
    }
}

