/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.util;

import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaxen.JaxenException;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;
import org.wso2.utils.ServerException;

public class XmlConfiguration {
    private static Log log = LogFactory.getLog((Class)XmlConfiguration.class);
    private StAXOMBuilder builder;
    private String serverNamespace = "http://www.wso2.org/products/wsas";

    public XmlConfiguration(String xmlFile) throws ServerException {
        this(xmlFile, null);
    }

    public XmlConfiguration(String xmlFile, String serverNamespace) throws ServerException {
        if (serverNamespace != null) {
            this.serverNamespace = serverNamespace;
        }
        try {
            this.builder = new StAXOMBuilder(xmlFile);
        }
        catch (Exception e) {
            String msg = "Error occurred while trying to instantiate StAXOMBuilder for XML file " + xmlFile;
            log.error((Object)msg, (Throwable)e);
            throw new ServerException(msg, (Throwable)e);
        }
    }

    public String getUniqueValue(String xPath) {
        SimpleNamespaceContext nsCtx = new SimpleNamespaceContext();
        nsCtx.addNamespace("ns", this.serverNamespace);
        try {
            Object obj;
            List nodeList;
            AXIOMXPath xp = new AXIOMXPath(xPath);
            xp.setNamespaceContext((NamespaceContext)nsCtx);
            OMElement elem = this.builder.getDocumentElement();
            if (elem != null && !(nodeList = xp.selectNodes((Object)elem)).isEmpty() && (obj = nodeList.get(0)) != null) {
                return ((OMElement)obj).getText();
            }
        }
        catch (JaxenException e) {
            throw new RuntimeException("XPath expression " + xPath + " failed", e);
        }
        return null;
    }

    public OMElement[] getElements(String xPath) {
        SimpleNamespaceContext nsCtx = new SimpleNamespaceContext();
        nsCtx.addNamespace("ns", this.serverNamespace);
        try {
            AXIOMXPath xp = new AXIOMXPath(xPath);
            xp.setNamespaceContext((NamespaceContext)nsCtx);
            OMElement elem = this.builder.getDocumentElement();
            if (elem != null) {
                List nodeList = xp.selectNodes((Object)elem);
                return nodeList.toArray(new OMElement[nodeList.size()]);
            }
        }
        catch (JaxenException e) {
            throw new RuntimeException("XPath expression " + xPath + " failed", e);
        }
        return new OMElement[0];
    }
}

