/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.wso2.utils.ServerConfiguration;

public class WsasUtils {
    public static boolean isAdminConsoleEnabled() {
        boolean enableAdminConsole = false;
        String enableAdminConsoleProp = ServerConfiguration.getInstance().getFirstProperty("Management.EnableConsole");
        if (enableAdminConsoleProp != null) {
            enableAdminConsole = Boolean.valueOf(enableAdminConsoleProp);
        }
        return enableAdminConsole;
    }

    public static void setServletContextProperties(ServletContext servletContext, Map generatedPages, boolean isAdminConsoleEnabled, int httpPort, int httpsPort, String servicePath) throws ServletException {
        servletContext.setAttribute("geneated.pages", (Object)generatedPages);
        servletContext.setAttribute("enable.console", (Object)isAdminConsoleEnabled);
        servletContext.setAttribute("http.port", (Object)(httpPort + ""));
        servletContext.setAttribute("https.port", (Object)(httpsPort + ""));
        servletContext.setAttribute("service.context.path", (Object)servicePath);
    }

    public static String getAxis2Xml() {
        String axis2XML = ServerConfiguration.getInstance().getFirstProperty("Axis2Config.ConfigurationFile");
        if (axis2XML == null) {
            axis2XML = System.getProperty("axis2.xml");
        }
        return axis2XML;
    }

    public static String getWsasServerXml() {
        String serverXML = System.getProperty("wso2wsas.server.xml");
        if (serverXML == null) {
            serverXML = System.getProperty("wso2wsas.home") + File.separator + "conf" + File.separator + "server.xml";
        }
        return serverXML;
    }

    public static boolean isURL(String location) {
        try {
            new URL(location);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public static Long lastUpdatedTime(AxisServiceGroup serviceGroup) {
        String axis2Repo = ServerConfiguration.getInstance().getFirstProperty("Axis2Config.RepositoryLocation");
        if (WsasUtils.isURL(axis2Repo)) {
            return null;
        }
        Long lastUpdated = null;
        String fileName = "";
        Iterator serviceIter = serviceGroup.getServices();
        while (serviceIter.hasNext()) {
            AxisService axisService = (AxisService)serviceIter.next();
            URL fn = axisService.getFileName();
            if (fn != null) {
                fileName = fn.getPath();
            }
            if (fileName == null || fileName.trim().length() == 0) continue;
            File file = new File(fileName);
            lastUpdated = new Long(file.lastModified());
            break;
        }
        return lastUpdated;
    }

    public static int getCommandListenerPort() {
        int serverPort = -1;
        ServerConfiguration serverConfig = ServerConfiguration.getInstance();
        String port = serverConfig.getFirstProperty("Ports.CommandListener");
        if (port == null) {
            port = serverConfig.getFirstProperty("CommandListener.Port");
        }
        if (port != null) {
            serverPort = Integer.parseInt(port);
        }
        return serverPort;
    }
}

