/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.util;

import java.util.HashMap;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.tracer.TracerUtils;
import org.wso2.tracer.module.TracePersister;
import org.wso2.wsas.persistence.PersistenceManager;
import org.wso2.wsas.persistence.dataobject.MessageDO;

public class TracePersisterImpl
implements TracePersister {
    private static final String TRACING_MAP = "local_wso2tracer.map";
    private static final String REQUEST_NUMBER = "local_wso2tracer.request.number";
    private static Log log = LogFactory.getLog((Class)TracePersisterImpl.class);
    private MessageContext msgContext;
    private static Log TRACE_LOGGER = LogFactory.getLog((String)"trace.messages");
    private PersistenceManager pm = new PersistenceManager();

    public void setMsgContext(MessageContext msgContext) {
        this.msgContext = msgContext;
    }

    public boolean isTracingEnabled() {
        String prop = this.pm.getConfigurationProperty("wso2tracer.status");
        return prop != null && prop.equalsIgnoreCase("ON");
    }

    public long saveMessage(String operationName, String serviceName, int flow, SOAPEnvelope env) {
        String xml;
        MessageDO msgDO = new MessageDO();
        msgDO.setServiceId(serviceName);
        msgDO.setOperationName(operationName);
        try {
            xml = TracerUtils.getPrettyString((SOAPEnvelope)env, (MessageContext)this.msgContext);
        }
        catch (Exception e) {
            String msg = " The received SOAP Message could not be serialized";
            log.warn((Object)msg, (Throwable)e);
            xml = msg + " : " + e;
        }
        msgDO.setXml(xml);
        if (TRACE_LOGGER.isTraceEnabled()) {
            TRACE_LOGGER.trace((Object)xml);
        }
        long msgSequence = this.getMessageSequence(serviceName + "." + operationName, serviceName, operationName);
        msgDO.setType(flow);
        msgDO.setSequence(msgSequence);
        this.pm.addMessage(msgDO);
        return msgSequence;
    }

    public void saveTraceStatus(String onOff) {
        this.pm.updateConfigurationProperty("wso2tracer.status", onOff);
    }

    public String[] getMessages(String serviceId, String operationName, long messageSequence) {
        MessageDO msg = new MessageDO();
        msg.setServiceId(serviceId);
        msg.setOperationName(operationName);
        msg.setSequence(messageSequence);
        MessageDO[] messages = this.pm.getMessages(msg);
        String[] resp = new String[2];
        if (messages != null && messages.length != 0) {
            for (int i = 0; i < messages.length; ++i) {
                MessageDO message = messages[i];
                if (message.getType() == 1 || message.getType() == 3) {
                    resp[0] = message.getXml();
                    continue;
                }
                if (message.getType() != 2 && message.getType() != 4) continue;
                resp[1] = message.getXml();
            }
        }
        return resp;
    }

    private long getMessageSequence(String key, String serviceName, String operationName) {
        long msgSequence = 1L;
        Object requestNumber = this.msgContext.getOperationContext().getProperty(REQUEST_NUMBER);
        if (requestNumber != null && requestNumber instanceof Long) {
            msgSequence = ((Long)requestNumber).intValue();
        } else {
            Object counterInt;
            HashMap<String, Long> monitoringHandlerMap = (HashMap<String, Long>)this.msgContext.getConfigurationContext().getProperty(TRACING_MAP);
            if (monitoringHandlerMap == null) {
                monitoringHandlerMap = new HashMap<String, Long>();
                this.msgContext.getConfigurationContext().setProperty(TRACING_MAP, monitoringHandlerMap);
            }
            if ((counterInt = monitoringHandlerMap.get(key)) == null) {
                PersistenceManager pm = new PersistenceManager();
                msgSequence = pm.getMaxMessageSequence(serviceName, "$EMPTY$", operationName) + 1L;
            } else if (counterInt instanceof Long) {
                msgSequence = ((Long)counterInt).intValue() + 1;
            }
            monitoringHandlerMap.put(serviceName + "." + operationName, new Long(msgSequence));
            this.msgContext.getOperationContext().setProperty(REQUEST_NUMBER, (Object)new Long(msgSequence));
        }
        return msgSequence;
    }
}

