/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.util;

import org.apache.log4j.Logger;
import org.wso2.wsas.ServerManagement;
import org.wso2.wsas.TomcatServerCache;
import org.wso2.wsas.util.Controllable;
import org.wso2.wsas.util.Monitor;

public class SystemRestarter
implements Runnable {
    private Controllable newInstance;
    private Controllable currentInstance;
    private static Logger log = Logger.getLogger((Class)SystemRestarter.class);
    private boolean gracefulRestart;

    public SystemRestarter(boolean gracefulRestart, Controllable currentInstance, Controllable newInstance, String axis2RepoLocation, Monitor m) {
        this.currentInstance = currentInstance;
        this.newInstance = newInstance;
        this.newInstance.setAxis2RepoLocation(axis2RepoLocation);
        this.newInstance.setMonitor(m);
        this.gracefulRestart = gracefulRestart;
    }

    public void run() {
        try {
            System.setProperty("wso2wsas.start.time", String.valueOf(System.currentTimeMillis()));
            if (this.gracefulRestart) {
                log.info((Object)"Gracefully restarting WSO2 WSAS...");
                new ServerManagement(this.currentInstance.getConfigurationContext().getAxisConfiguration().getTransportsIn()).startMaintenance();
            } else {
                log.info((Object)"Restarting WSO2 WSAS...");
            }
            TomcatServerCache.removeAllConnectors();
            this.currentInstance.stopListeners();
            this.newInstance.startServer();
        }
        catch (Exception e) {
            String msg = "Cannot restart system";
            log.fatal((Object)msg, (Throwable)e);
        }
    }
}

