/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.utils.ServerException;
import org.wso2.wsas.util.Controllable;

public class ServerController
implements Runnable {
    public static final String LOCAL_HOST_IP = "127.0.0.1";
    public static final String SHUTDOWN_COMMAND = "shutdownserver";
    public static final String RESTART_COMMAND = "restartserver";
    public static ServerSocket serverSocket;
    private Controllable controllable;
    private int port;
    private static Log log;

    public ServerController(Controllable controllable) {
        this.controllable = controllable;
    }

    public ServerController() {
    }

    public void run() {
        this.listenForCommands();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listenForCommands() {
        try {
            serverSocket = new ServerSocket(this.port, 1, InetAddress.getByName(LOCAL_HOST_IP));
        }
        catch (IOException e) {
            log.error((Object)("Cannot listen on port " + this.port + ". May be it is in use."), (Throwable)e);
            System.exit(1);
        }
        block11: while (true) {
            try {
                while (true) {
                    int ch;
                    Socket socket = serverSocket.accept();
                    InputStream inputStream = socket.getInputStream();
                    StringBuffer stringBuffer = new StringBuffer();
                    while ((ch = inputStream.read()) != -1) {
                        stringBuffer.append((char)ch);
                    }
                    String command = stringBuffer.toString();
                    log.debug((Object)("Received Command ==> " + command));
                    if (command.equals(SHUTDOWN_COMMAND)) {
                        try {
                            inputStream.close();
                            socket.close();
                            serverSocket.close();
                            this.controllable.shutdownGracefully();
                            continue block11;
                        }
                        catch (Exception e) {
                            log.error((Object)"Exception while shutting down server", (Throwable)e);
                            continue;
                        }
                    }
                    if (command.equals(RESTART_COMMAND)) {
                        try {
                            log.info((Object)"Restarting WSO2 WSAS...");
                            this.controllable.restart();
                        }
                        catch (ServerException e) {
                            log.error((Object)"Exception while restarting the server", (Throwable)e);
                        }
                        finally {
                            inputStream.close();
                            socket.close();
                            serverSocket.close();
                        }
                        continue;
                    }
                    log.error((Object)("Invalid command : " + command));
                }
            }
            catch (IOException e) {
                log.error((Object)("Cannot listen on port " + this.port + ". May be it is in use."), (Throwable)e);
                System.exit(1);
                continue;
            }
            break;
        }
    }

    public void shutDownServer() {
        try {
            Socket socket = new Socket(LOCAL_HOST_IP, this.port);
            OutputStream outStream = socket.getOutputStream();
            for (int i = 0; i < SHUTDOWN_COMMAND.length(); ++i) {
                outStream.write(SHUTDOWN_COMMAND.charAt(i));
            }
            outStream.flush();
            outStream.close();
            socket.close();
            System.out.println(" Shutdown signal posted to WSO2 WSAS");
            System.out.println(" Server shutdown may take some time. Please check the server's log file for completion.");
        }
        catch (IOException e) {
            System.err.println(" Could not connect to WSO2 WSAS controller at 127.0.0.1:" + this.port);
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void restartServer() {
        try {
            Socket socket = new Socket(LOCAL_HOST_IP, this.port);
            OutputStream outStream = socket.getOutputStream();
            for (int i = 0; i < RESTART_COMMAND.length(); ++i) {
                outStream.write(RESTART_COMMAND.charAt(i));
            }
            outStream.flush();
            outStream.close();
            socket.close();
            System.out.println(" Restart signal posted to WSO2 WSAS");
            System.out.println(" Server restart may take some time. Please check the server's log file for completion.");
        }
        catch (IOException e) {
            System.err.println(" Could not connect to WSO2 WSAS controller at 127.0.0.1:" + this.port);
            e.printStackTrace();
            System.exit(1);
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    static {
        log = LogFactory.getLog((Class)ServerController.class);
    }
}

