/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.util;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.wso2.utils.InputReader;
import org.wso2.utils.ServerConfiguration;
import org.wso2.utils.ServerConfigurationException;
import org.wso2.utils.security.CryptoException;
import org.wso2.utils.security.CryptoUtil;

public class PasswordUpdater {
    public static final String DB_URL = "--db-url";
    public static final String DB_DRIVER = "--db-driver";
    public static final String DB_USERNAME = "--db-username";
    public static final String DB_PASSWORD = "--db-password";
    public static final String USERNAME = "--username";
    public static final String NEW_PASSWORD = "--new-password";

    public static void main(String[] args) {
        new PasswordUpdater().run(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(String[] args) {
        String dbPassword;
        String dbUsername;
        String dbDriver;
        String dbURL;
        String wso2wsasHome = System.getProperty("wso2wsas.home");
        if (wso2wsasHome == null) {
            wso2wsasHome = new File(".").getAbsolutePath();
            System.setProperty("wso2wsas.home", wso2wsasHome);
        }
        if (args.length == 0) {
            this.printUsage();
            System.exit(0);
        }
        if ((dbURL = this.getParam(DB_URL, args)) == null || dbURL.indexOf("jdbc:") != 0) {
            System.err.println(" Invalid database DB_URL : " + dbURL);
            this.printUsage();
            System.exit(0);
        }
        if ((dbDriver = this.getParam(DB_DRIVER, args)) == null) {
            dbDriver = "org.apache.derby.jdbc.EmbeddedDriver";
        }
        if ((dbUsername = this.getParam(DB_USERNAME, args)) == null) {
            dbUsername = "wso2wsas";
        }
        if ((dbPassword = this.getParam(DB_PASSWORD, args)) == null) {
            dbPassword = "wso2wsas";
        }
        try {
            Class.forName(dbDriver);
        }
        catch (ClassNotFoundException e) {
            System.err.println(" Database driver [" + dbDriver + "] not found in classpath.");
            System.exit(1);
        }
        Connection conn = null;
        try {
            conn = DriverManager.getConnection(dbURL, dbUsername, dbPassword);
        }
        catch (Exception e) {
            System.err.println("Cannot connect to database. \nPlease make sure that the JDBC URL is correct and that you have \nstopped WSO2 WSAS before running this script. Root cause is : \n" + e);
            System.exit(1);
        }
        String username = this.getParam(USERNAME, args);
        while (username == null || username.trim().length() == 0) {
            System.out.print("Username: ");
            try {
                username = InputReader.readInput();
            }
            catch (IOException e) {
                System.err.println(" Could not read username : " + e);
                System.exit(1);
            }
        }
        String password = this.getParam(NEW_PASSWORD, args);
        if (password == null || password.trim().length() == 0) {
            String passwordRepeat = null;
            while (password == null || password.trim().length() == 0) {
                try {
                    password = InputReader.readPassword((String)"New password: ");
                }
                catch (IOException e) {
                    System.err.println("Unable to read password : " + e);
                    System.exit(1);
                }
            }
            while (passwordRepeat == null || passwordRepeat.trim().length() == 0) {
                try {
                    passwordRepeat = InputReader.readPassword((String)"Re-enter new password: ");
                }
                catch (IOException e) {
                    System.err.println("Unable to read re-entered password : " + e);
                    System.exit(1);
                }
            }
            if (!password.equals(passwordRepeat)) {
                System.err.println(" Password and re-entered password do not match");
                System.exit(1);
            }
        }
        Statement statement = null;
        try {
            ServerConfiguration config = ServerConfiguration.getInstance();
            config.init(Thread.currentThread().getContextClassLoader().getResourceAsStream("server.xml"));
            password = new CryptoUtil(new File(config.getFirstProperty("Security.KeyStore.Location")).getAbsolutePath(), config.getFirstProperty("Security.KeyStore.Password"), config.getFirstProperty("Security.KeyStore.KeyAlias"), config.getFirstProperty("Security.KeyStore.KeyPassword"), config.getFirstProperty("Security.KeyStore.Type")).encryptAndBase64Encode(password.getBytes());
            String sql = "update service_user_t set c_password=? where c_username=?";
            statement = conn.prepareStatement(sql);
            statement.setString(1, password);
            statement.setString(2, username.trim());
            statement.execute();
            if (statement.getUpdateCount() == 0) {
                System.err.println(" User with name '" + username + "' does not exist.");
            } else {
                System.out.println(" Password of user '" + username + "' updated successfully");
            }
        }
        catch (SQLException e) {
            System.err.println(" Could not update password : " + e);
        }
        catch (CryptoException e) {
            e.printStackTrace();
            System.err.println(" Password encyption failed : " + (Object)((Object)e));
        }
        catch (ServerConfigurationException e) {
            e.printStackTrace();
            System.err.println(" Server error : " + (Object)((Object)e));
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    System.err.println(" Could not close statement : " + e);
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    System.err.println(" Could not close connection : " + e);
                }
            }
        }
    }

    private String getParam(String param, String[] args) {
        if (param == null || "".equals(param)) {
            return null;
        }
        for (int i = 0; i < args.length; i += 2) {
            String arg = args[i];
            if (!param.equalsIgnoreCase(arg) || args.length < i + 1) continue;
            return args[i + 1];
        }
        return null;
    }

    private void printUsage() {
        System.out.println("Usage: chpasswd --db-url DB_URL [OPTIONS]\n");
        System.out.println("         --db-url : The JDBC database URL. e.g. jdbc:derby:/home/wso2wsas/database/WSO2WSAS_DB\n");
        System.out.println("Options");
        System.out.println("         --db-driver    : The database driver class. e.g. org.apache.derby.jdbc.EmbeddedDriver");
        System.out.println("         --db-username  : The database username");
        System.out.println("         --db-password  : The database password");
        System.out.println("         --username     : The username of the user whose password is to be changed. If this is not given, you will be prompted for this field later.");
        System.out.println("         --new-password : The new password of the user whose password is to be changed. If this is not given, you will be prompted for this field later.");
    }
}

