/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.util;

import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.wso2.utils.i18n.Messages;

public class Monitor
extends Thread {
    private ServerSocket serverSocket;
    private String key = Monitor.getKey();

    public static String getKey() {
        return Messages.getMessage((String)"serverVersionRaw") + " " + Messages.getMessage((String)"serverBuiltOnRaw");
    }

    public Monitor(int port) {
        try {
            if (port < 0) {
                return;
            }
            this.setDaemon(true);
            this.serverSocket = new ServerSocket(port, 1, InetAddress.getByName("127.0.0.1"));
            if (port == 0) {
                port = this.serverSocket.getLocalPort();
                System.out.println(port);
            }
        }
        catch (Exception e) {
            System.err.println(e.toString());
        }
        if (this.serverSocket == null) {
            throw new RuntimeException(Messages.getMessage((String)"InvalidAdminPort", (String)Integer.toString(port)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            if (this.serverSocket == null) {
                return;
            }
            Socket socket = null;
            try {
                socket = this.serverSocket.accept();
                LineNumberReader lin = new LineNumberReader(new InputStreamReader(socket.getInputStream()));
                String key = lin.readLine();
                if (!this.key.equals(key)) continue;
                String cmd = lin.readLine();
                if ("STOP".equals(cmd)) {
                    socket.getOutputStream().write("DONE\r\n".getBytes());
                    socket.getOutputStream().flush();
                    try {
                        socket.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        this.serverSocket.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    System.exit(0);
                    continue;
                }
                if ("RESTART".equals(cmd)) {
                    socket.getOutputStream().write("DONE\r\n".getBytes());
                    socket.getOutputStream().flush();
                    try {
                        socket.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        this.serverSocket.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
                if (!"STATUS".equals(cmd)) continue;
                socket.getOutputStream().write("OK\r\n".getBytes());
                socket.getOutputStream().flush();
                continue;
            }
            catch (Exception e) {
                System.err.println(e.toString());
                continue;
            }
            finally {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (Exception exception) {}
                }
                socket = null;
                continue;
            }
            break;
        }
    }
}

