/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.util;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.log4j.Logger;

public class MIMEType2FileExtensionMap {
    public static String mappingFileName = "conf/mime-mappings.xml";
    private Map extensionToMimeMap = new HashMap();
    public static MIMEType2FileExtensionMap instance;
    private static Logger log;

    public static MIMEType2FileExtensionMap getInstance() {
        if (instance == null) {
            instance = new MIMEType2FileExtensionMap();
        }
        return instance;
    }

    private MIMEType2FileExtensionMap() {
        this.init();
    }

    public String getMIMEType(File file) {
        String filename = file.getName();
        int index = filename.lastIndexOf(".");
        if (index == -1 || index == filename.length() - 1) {
            return "application/octet-stream";
        }
        String extension = filename.substring(index + 1);
        String contentType = (String)this.extensionToMimeMap.get(extension);
        return contentType != null ? contentType : "application/octet-stream";
    }

    private void init() {
        try {
            OMElement doc = new StAXOMBuilder(mappingFileName).getDocumentElement();
            Iterator childIter = doc.getChildElements();
            while (childIter.hasNext()) {
                OMElement mappingEle = (OMElement)childIter.next();
                String ext = mappingEle.getFirstChildWithName(new QName("Extension")).getText();
                String mimeType = mappingEle.getFirstChildWithName(new QName("MimeType")).getText();
                this.extensionToMimeMap.put(ext, mimeType);
            }
        }
        catch (Exception e) {
            String msg = "Unable to load all MIME Mappings";
            e.printStackTrace();
            log.error((Object)msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
    }

    static {
        log = Logger.getLogger((Class)MIMEType2FileExtensionMap.class);
    }
}

