/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.net.SyslogAppender;
import org.springframework.util.Log4jConfigurer;
import org.wso2.utils.CircularBuffer;
import org.wso2.utils.MemoryAppender;
import org.wso2.wsas.persistence.PersistenceManager;
import org.wso2.wsas.persistence.dataobject.AppenderDO;
import org.wso2.wsas.persistence.dataobject.LoggerDO;

public class LoggingUtil {
    private static final Log log = LogFactory.getLog((Class)LoggingUtil.class);
    private static PersistenceManager pm = new PersistenceManager();

    public static void setSystemLoggingParameters(String logLevel, String logPattern) {
        System.setProperty("wso2wsas.system.log.level", logLevel);
        System.setProperty("wso2wsas.system.log.pattern", logPattern);
    }

    public static String getSystemLogLevel() {
        return System.getProperty("wso2wsas.system.log.level");
    }

    public static String getSystemLogPattern() {
        return System.getProperty("wso2wsas.system.log.pattern");
    }

    public static void loadDefaultConfiguration() {
        LoggingUtil.loadDefaultGlobalLogSettings();
        HashSet appenderSet = new HashSet();
        Logger rootLogger = LogManager.getRootLogger();
        Enumeration appenders = rootLogger.getAllAppenders();
        LoggingUtil.addAppendersToSet(appenders, appenderSet);
        Enumeration loggers = LogManager.getCurrentLoggers();
        while (loggers.hasMoreElements()) {
            Logger logger = (Logger)loggers.nextElement();
            LoggerDO loggerDO = LoggingUtil.toLoggerDO(logger);
            if (loggerDO != null) {
                pm.addLogger(loggerDO);
            }
            LoggingUtil.addAppendersToSet(logger.getAllAppenders(), appenderSet);
        }
        Iterator iter = appenderSet.iterator();
        while (iter.hasNext()) {
            Appender appender = (Appender)iter.next();
            AppenderDO appenderDO = LoggingUtil.toAppenderDO(appender);
            pm.addAppender(appenderDO);
        }
    }

    public static void restoreDefaults() throws AxisFault {
        pm.removeAllLoggersAndAppenders();
        pm.updateConfigurationProperty("wso2wsas.system.log.is.loaded", "false");
        LogManager.resetConfiguration();
        try {
            Log4jConfigurer.initLogging((String)"classpath:log4j.properties");
        }
        catch (FileNotFoundException e) {
            String msg = "Cannot restore default logging configuration. log4j.properties file not found in the classpath";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
    }

    public static void loadCustomConfiguration() {
        HashSet appenderSet = new HashSet();
        Logger rootLogger = LogManager.getRootLogger();
        String rootLoggerLevel = pm.getConfigurationProperty("wso2wsas.system.log.level");
        rootLogger.setLevel(Level.toLevel((String)rootLoggerLevel));
        String systemLogPattern = pm.getConfigurationProperty("wso2wsas.system.log.pattern");
        LoggingUtil.setSystemLoggingParameters(rootLoggerLevel, systemLogPattern);
        LoggingUtil.addAppendersToSet(rootLogger.getAllAppenders(), appenderSet);
        Enumeration loggers = LogManager.getCurrentLoggers();
        while (loggers.hasMoreElements()) {
            Logger logger = (Logger)loggers.nextElement();
            LoggingUtil.addAppendersToSet(logger.getAllAppenders(), appenderSet);
            LoggerDO loggerDO = pm.getLoggerDO(logger.getName());
            if (loggerDO == null) continue;
            logger.setLevel(Level.toLevel((String)loggerDO.getLogLevel()));
            logger.setAdditivity(loggerDO.getAdditivity());
        }
        Iterator iter = appenderSet.iterator();
        while (iter.hasNext()) {
            Appender appender = (Appender)iter.next();
            AppenderDO appenderDO = pm.getAppenderDO(appender.getName());
            if (appenderDO == null) continue;
            if (appender.getLayout() != null && appender.getLayout() instanceof PatternLayout) {
                ((PatternLayout)appender.getLayout()).setConversionPattern(appenderDO.getPattern());
            }
            if (appender instanceof FileAppender) {
                FileAppender fileAppender = (FileAppender)appender;
                fileAppender.setFile(appenderDO.getLogFileName());
                fileAppender.activateOptions();
            }
            if (appender instanceof MemoryAppender) {
                MemoryAppender memoryAppender = (MemoryAppender)appender;
                memoryAppender.setCircularBuffer(new CircularBuffer(200));
                memoryAppender.activateOptions();
            }
            if (appender instanceof SyslogAppender) {
                SyslogAppender syslogAppender = (SyslogAppender)appender;
                syslogAppender.setSyslogHost(appenderDO.getSysLogHost());
                syslogAppender.setFacility(appenderDO.getFacility());
            }
            if (!(appender instanceof AppenderSkeleton)) continue;
            AppenderSkeleton appenderSkeleton = (AppenderSkeleton)appender;
            appenderSkeleton.setThreshold((Priority)Level.toLevel((String)appenderDO.getThreshold()));
            appenderSkeleton.activateOptions();
        }
    }

    private static void loadDefaultGlobalLogSettings() {
        pm.updateConfigurationProperty("wso2wsas.system.log.is.loaded", "true");
        String systemLogLevel = Logger.getRootLogger().getLevel().toString();
        pm.updateConfigurationProperty("wso2wsas.system.log.level", systemLogLevel);
        String systemLogPattern = "%5p [%d] %x %m%n";
        pm.updateConfigurationProperty("wso2wsas.system.log.pattern", systemLogPattern);
        LoggingUtil.setSystemLoggingParameters(systemLogLevel, systemLogPattern);
    }

    private static void addAppendersToSet(Enumeration appenders, Set appenderSet) {
        while (appenders.hasMoreElements()) {
            Appender appender = (Appender)appenders.nextElement();
            appenderSet.add(appender);
        }
    }

    public static LoggerDO toLoggerDO(Logger logger) {
        LoggerDO loggerDO = new LoggerDO();
        loggerDO.setName(logger.getName());
        loggerDO.setLogLevel(logger.getEffectiveLevel().toString());
        loggerDO.setAdditivity(logger.getAdditivity());
        return loggerDO;
    }

    private static AppenderDO toAppenderDO(Appender appender) {
        Layout layout;
        AppenderDO appenderDO = new AppenderDO();
        appenderDO.setName(appender.getName());
        if (appender.requiresLayout() && (layout = appender.getLayout()) instanceof PatternLayout) {
            appenderDO.setPattern(((PatternLayout)layout).getConversionPattern());
        }
        if (appender instanceof FileAppender) {
            FileAppender fileAppender = (FileAppender)appender;
            String fileName = fileAppender.getFile();
            File logFile = new File(fileName);
            if (!logFile.isAbsolute()) {
                if (fileName.startsWith(".")) {
                    fileName = fileName.substring(1);
                }
                fileName = (System.getProperty("wso2wsas.home") + "/" + fileName).replace('\\', '/');
                fileAppender.setFile(fileName);
                fileAppender.activateOptions();
            }
            appenderDO.setLogFileName(fileName);
            appenderDO.setIsFileAppender(true);
        } else {
            appenderDO.setIsFileAppender(false);
        }
        if (appender instanceof MemoryAppender) {
            MemoryAppender memoryAppender = (MemoryAppender)appender;
            memoryAppender.setCircularBuffer(new CircularBuffer(200));
            memoryAppender.activateOptions();
        }
        if (appender instanceof AppenderSkeleton) {
            AppenderSkeleton appenderSkeleton = (AppenderSkeleton)appender;
            if (appenderSkeleton.getThreshold() != null) {
                appenderDO.setThreshold(appenderSkeleton.getThreshold().toString());
            } else {
                appenderDO.setThreshold("DEBUG");
            }
        }
        if (appender instanceof SyslogAppender) {
            SyslogAppender syslogAppender = (SyslogAppender)appender;
            appenderDO.setSysLogHost(syslogAppender.getSyslogHost());
            appenderDO.setFacility(syslogAppender.getFacility());
            appenderDO.setIsSysLogAppender(true);
        } else {
            appenderDO.setIsSysLogAppender(false);
        }
        return appenderDO;
    }
}

