/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.Date;
import java.util.Enumeration;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.utils.ServerConfiguration;
import org.wso2.utils.ServerException;
import org.wso2.utils.security.CryptoException;
import org.wso2.utils.security.CryptoUtil;
import org.wso2.wsas.persistence.PersistenceManager;
import org.wso2.wsas.persistence.dataobject.KeyStoreDO;
import org.wso2.wsas.persistence.exception.KeyStoreAlreadyExistsException;

public final class KeyStoreUtil {
    private static PersistenceManager pm = new PersistenceManager();
    private static Log log = LogFactory.getLog((Class)KeyStoreUtil.class);

    private KeyStoreUtil() {
    }

    public static synchronized boolean keyStoreExists(String keyStoreLocation) {
        return pm.getKeyStore(KeyStoreUtil.getKeyStoreName(keyStoreLocation)) != null;
    }

    public static synchronized void persistKeyStore(String keyStoreLocation, String keyStorePassword, String keyStoreType, String privateKeyAlias, String privateKeyPassword, String provider, boolean isPrimaryKeyStore) throws KeyStoreAlreadyExistsException, ServerException {
        KeyStoreDO keyStoreDO;
        String ksName = KeyStoreUtil.getKeyStoreName(keyStoreLocation);
        if (pm.getKeyStore(ksName) == null) {
            keyStoreDO = new KeyStoreDO();
            keyStoreDO.setKeyStoreName(ksName);
            keyStoreDO.setIsPrimaryKeyStore(isPrimaryKeyStore);
            if (!new File(keyStoreLocation).isAbsolute()) {
                keyStoreLocation = System.getProperty("wso2wsas.home") + File.separator + keyStoreLocation;
            }
            keyStoreDO.setFilePath(keyStoreLocation);
            keyStoreDO.setKeyStoreType(keyStoreType);
            keyStoreDO.setProvider(provider);
            keyStoreDO.setLastUpdatedTime(new Date());
            keyStoreDO.setPrivateKeyAlias(privateKeyAlias);
            try {
                ServerConfiguration config = ServerConfiguration.getInstance();
                CryptoUtil cryptoUtil = new CryptoUtil(new File(config.getFirstProperty("Security.KeyStore.Location")).getAbsolutePath(), config.getFirstProperty("Security.KeyStore.Password"), config.getFirstProperty("Security.KeyStore.KeyAlias"), config.getFirstProperty("Security.KeyStore.KeyPassword"), config.getFirstProperty("Security.KeyStore.Type"));
                keyStoreDO.setPrivateKeyPassword(cryptoUtil.encryptAndBase64Encode(privateKeyPassword.getBytes()));
                keyStoreDO.setStorePassword(cryptoUtil.encryptAndBase64Encode(keyStorePassword.getBytes()));
            }
            catch (CryptoException e) {
                throw new ServerException("Cannot encrypt WSO2 WSAS store and/or private key passwords", (Throwable)e);
            }
        } else {
            throw new KeyStoreAlreadyExistsException("Keystore with name " + ksName + " already exists");
        }
        pm.addKeyStore(keyStoreDO);
    }

    private static String getKeyStoreName(String keyStoreLocation) {
        String ksName = keyStoreLocation;
        if (keyStoreLocation.indexOf("/") != -1) {
            int index = keyStoreLocation.lastIndexOf("/");
            if (index != -1) {
                ksName = keyStoreLocation.substring(index + 1);
            }
        } else {
            int index = keyStoreLocation.lastIndexOf("\\");
            if (index != -1) {
                ksName = keyStoreLocation.substring(index + 1);
            }
        }
        return ksName;
    }

    public static Certificate getCertificate(String keyStoreName, String alias) throws AxisFault {
        try {
            KeyStore keyStore = KeyStoreUtil.getKeyStore(keyStoreName);
            Enumeration<String> enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                String itemAlias = enumeration.nextElement();
                if (!itemAlias.equals(alias)) continue;
                return keyStore.getCertificate(alias);
            }
            return null;
        }
        catch (Exception e) {
            String msg = "Could not read certificates from keystore file. ";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore getKeyStore(String keyStoreName) throws Exception {
        KeyStoreDO keyStoreDO = pm.getKeyStore(keyStoreName);
        KeyStore keyStore = KeyStore.getInstance(keyStoreDO.getKeyStoreType());
        String filePath = keyStoreDO.getFilePath();
        if (!new File(filePath).isAbsolute()) {
            filePath = System.getProperty("wso2wsas.home") + File.separator + filePath;
        }
        FileInputStream ksIn = new FileInputStream(filePath);
        BufferedInputStream ksbufin = new BufferedInputStream(ksIn);
        try {
            String storePassword = keyStoreDO.getStorePassword();
            ServerConfiguration config = ServerConfiguration.getInstance();
            CryptoUtil cryptoUtil = new CryptoUtil(new File(config.getFirstProperty("Security.KeyStore.Location")).getAbsolutePath(), config.getFirstProperty("Security.KeyStore.Password"), config.getFirstProperty("Security.KeyStore.KeyAlias"), config.getFirstProperty("Security.KeyStore.KeyPassword"), config.getFirstProperty("Security.KeyStore.Type"));
            keyStore.load(ksbufin, new String(cryptoUtil.base64DecodeAndDecrypt(storePassword)).toCharArray());
        }
        finally {
            ksIn.close();
            ksbufin.close();
        }
        return keyStore;
    }
}

