/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.TimerTask;
import org.apache.commons.collections.BidiMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.utils.FileManipulator;
import org.wso2.utils.ServerConfiguration;

public class HouseKeepingTask
extends TimerTask {
    private static Log log = LogFactory.getLog((Class)HouseKeepingTask.class);
    private String workDir;
    private BidiMap fileResourceMap;
    private FileManipulator fileMan;
    private int fileTimeoutMillis;

    public HouseKeepingTask(String workDir, BidiMap fileResourceMap) {
        this.workDir = workDir;
        this.fileResourceMap = fileResourceMap;
        this.fileMan = new FileManipulator();
        this.fileTimeoutMillis = Integer.parseInt(ServerConfiguration.getInstance().getFirstProperty("HouseKeeping.MaxTempFileLifetime")) * 60 * 1000;
    }

    public void run() {
        log.debug((Object)"Starting house-keeping task...");
        File workDir = new File(this.workDir);
        if (workDir.exists()) {
            ArrayList deletedFiles = new ArrayList();
            this.clean(workDir, deletedFiles);
            log.debug((Object)"Clearing filemap cache...");
            if (this.fileResourceMap != null) {
                Iterator iterator = deletedFiles.iterator();
                while (iterator.hasNext()) {
                    this.fileResourceMap.removeValue(iterator.next());
                }
            }
        }
        log.debug((Object)"House-keeping complete.");
    }

    private void clean(File file, Collection deletedFiles) {
        File[] children = file.listFiles();
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                this.clean(children[i], deletedFiles);
            }
            if (file.listFiles() == null || file.listFiles().length == 0) {
                String absPath = file.getAbsolutePath();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Deleting directory " + absPath + "..."));
                }
                deletedFiles.add(absPath);
                this.fileMan.deleteDir(file);
            }
        } else if (System.currentTimeMillis() - file.lastModified() >= (long)this.fileTimeoutMillis) {
            String absPath = file.getAbsolutePath();
            if (file.isDirectory()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Deleting directory " + absPath + "..."));
                }
                deletedFiles.add(absPath);
                this.fileMan.deleteDir(file);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Deleting file " + absPath + "..."));
                }
                deletedFiles.add(absPath);
                file.delete();
            }
        }
    }

    public void setWorkDir(String workDir) {
        this.workDir = workDir;
    }

    public void setFileResourceMap(BidiMap fileResourceMap) {
        this.fileResourceMap = fileResourceMap;
    }
}

