/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.util;

import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;

public class HibernateConfig {
    private final SessionFactory SESSION_FACTORY;
    private final ThreadLocal SESSION = new ThreadLocal();

    public HibernateConfig(String dbConnIdentifier, String dbDriver, String sqlDialect, String username, String password, Class[] dataObjects) {
        if (!this.validateRequiredParams(new Object[]{dbConnIdentifier, dbDriver, sqlDialect, dataObjects})) {
            throw new IllegalArgumentException("One or more of the required parameters were not provided");
        }
        try {
            Configuration cfg = new Configuration();
            for (int i = 0; i < dataObjects.length; ++i) {
                cfg.addClass(dataObjects[i]);
            }
            this.commonInit(cfg, sqlDialect, dbDriver, dbConnIdentifier, username, password);
            this.SESSION_FACTORY = cfg.buildSessionFactory();
        }
        catch (Throwable ex) {
            System.err.println("Initial SessionFactory creation failed." + ex);
            throw new ExceptionInInitializerError(ex);
        }
    }

    public HibernateConfig(String dbConnIdentifier, String dbDriver, String sqlDialect, String username, String password, String[] hbmXMLFilenames) {
        if (!this.validateRequiredParams(new Object[]{dbConnIdentifier, dbDriver, sqlDialect, hbmXMLFilenames})) {
            throw new IllegalArgumentException("One or more of the required parameters were not provided");
        }
        try {
            Configuration cfg = new Configuration();
            for (int i = 0; i < hbmXMLFilenames.length; ++i) {
                cfg.addResource(hbmXMLFilenames[i]);
            }
            this.commonInit(cfg, sqlDialect, dbDriver, dbConnIdentifier, username, password);
            this.SESSION_FACTORY = cfg.buildSessionFactory();
        }
        catch (Throwable ex) {
            System.err.println("Initial SessionFactory creation failed." + ex);
            throw new ExceptionInInitializerError(ex);
        }
    }

    HibernateConfig() {
        try {
            this.SESSION_FACTORY = new Configuration().configure("wso2wsas.hibernate.cfg.xml").buildSessionFactory();
        }
        catch (Throwable ex) {
            System.err.println("Initial SessionFactory creation failed." + ex);
            throw new ExceptionInInitializerError(ex);
        }
    }

    private void commonInit(Configuration cfg, String sqlDialect, String dbDriver, String dbConnIdentifier, String username, String password) {
        cfg.setProperty("hibernate.dialect", sqlDialect);
        if (dbConnIdentifier.indexOf("java:comp") == 0) {
            cfg.setProperty("hibernate.connection.datasource", dbConnIdentifier);
        } else {
            cfg.setProperty("hibernate.connection.url", dbConnIdentifier);
            if (username != null && username.trim().length() != 0) {
                cfg.setProperty("hibernate.connection.username", username);
            }
            if (password != null && password.trim().length() != 0) {
                cfg.setProperty("hibernate.connection.password", password);
            }
            cfg.setProperty("hibernate.connection.driver_class", dbDriver);
        }
    }

    private boolean validateRequiredParams(Object[] params) {
        if (params == null) {
            return false;
        }
        for (int i = 0; i < params.length; ++i) {
            Object param = params[i];
            if (param == null) {
                return false;
            }
            if (param instanceof String && ((String)param).trim().length() == 0) {
                return false;
            }
            if (!(param instanceof Object[]) || this.validateRequiredParams((Object[])param)) continue;
            return false;
        }
        return true;
    }

    public Session currentSession() throws HibernateException {
        Session session = (Session)this.SESSION.get();
        if (session == null) {
            session = this.SESSION_FACTORY.openSession();
            this.SESSION.set(session);
        }
        return session;
    }

    public void closeSession() throws HibernateException {
        Session session = (Session)this.SESSION.get();
        if (session != null) {
            session.close();
        }
        this.SESSION.set(null);
    }
}

