/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axis2.context.ConfigurationContext;
import org.wso2.utils.ServerException;
import org.wso2.wsas.util.MIMEType2FileExtensionMap;

public class FileDownloadUtil {
    public synchronized boolean acquireResource(ConfigurationContext configurationContext, HttpServletRequest request, HttpServletResponse response) throws ServerException {
        ServletOutputStream out;
        try {
            out = response.getOutputStream();
        }
        catch (IOException e) {
            throw new ServerException("Unable to retrieve file ", (Throwable)e);
        }
        Map fileResourcesMap = (Map)configurationContext.getProperty("file.resource.map");
        String filename = (String)fileResourcesMap.get(request.getParameter("id"));
        if (filename == null) {
            try {
                out.write("The requested file was not found on the server".getBytes());
                out.flush();
                out.close();
            }
            catch (IOException e) {
                throw new ServerException("Unable to write output to HttpServletResponse OutputStream", (Throwable)e);
            }
            return false;
        }
        try {
            File file = new File(filename);
            FileInputStream in = new FileInputStream(file);
            byte[] b = new byte[(int)file.length()];
            response.setContentType(MIMEType2FileExtensionMap.getInstance().getMIMEType(file));
            response.setContentLength((int)file.length());
            response.setHeader("Content-Disposition", "filename=" + file.getName());
            int lengthRead = in.read(b);
            if (lengthRead != -1) {
                out.write(b);
            }
            out.flush();
            out.close();
            in.close();
            return true;
        }
        catch (IOException e) {
            throw new ServerException("Unable to retrieve file ", (Throwable)e);
        }
    }
}

