/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.util;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.axis2.AxisFault;
import org.apache.axis2.clustering.ClusterManager;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.rpc.receivers.RPCInOnlyMessageReceiver;
import org.apache.axis2.rpc.receivers.RPCMessageReceiver;

public class ClusteringUtil {
    private static boolean isClusterManagerInitialized;

    public static void enableClustering(ConfigurationContext configContext) throws AxisFault {
        AxisConfiguration axisConfig = configContext.getAxisConfiguration();
        ClusterManager clusterManager = axisConfig.getClusterManager();
        if (clusterManager != null) {
            clusterManager.setConfigurationContext(configContext);
            if (!isClusterManagerInitialized) {
                clusterManager.init();
                isClusterManagerInitialized = true;
            }
            if (clusterManager.getConfigurationManager() != null) {
                HashMap<String, Object> msgReceiverMap = new HashMap<String, Object>();
                msgReceiverMap.put("http://www.w3.org/ns/wsdl/in-out", new RPCMessageReceiver());
                msgReceiverMap.put("http://www.w3.org/ns/wsdl/in-only", new RPCInOnlyMessageReceiver());
                msgReceiverMap.put("http://www.w3.org/ns/wsdl/robust-in-only", new RPCInOnlyMessageReceiver());
                AxisService nodeManagerService = AxisService.createService((String)"org.wso2.wsas.clustering.NodeManager", (AxisConfiguration)axisConfig, msgReceiverMap, null, (String)"http://org.apache.axis2/xsd", (ClassLoader)clusterManager.getClass().getClassLoader());
                ArrayList<String> transports = new ArrayList<String>();
                transports.add("https");
                nodeManagerService.setExposedTransports(transports);
                nodeManagerService.setName("Axis2NodeManager");
                nodeManagerService.setScope("transportsession");
                nodeManagerService.setElementFormDefault(false);
                AxisServiceGroup adminSG = axisConfig.getServiceGroup("wso2wsas-administration");
                if (adminSG != null) {
                    try {
                        adminSG.addService(nodeManagerService);
                    }
                    catch (Exception e) {
                        throw AxisFault.makeFault((Throwable)e);
                    }
                } else {
                    axisConfig.addService(nodeManagerService);
                }
            }
            configContext.setNonReplicableProperty("local_cluster.initialized", (Object)"true");
        }
    }
}

