/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.trust;

import org.apache.rahas.SimpleTokenStore;
import org.apache.rahas.Token;
import org.apache.rahas.TrustException;
import org.wso2.wsas.persistence.PersistenceManager;
import org.wso2.wsas.persistence.dataobject.SecurityTokenDO;
import org.wso2.wsas.persistence.exception.TokenAlreadyExistsException;

public class SecurityTokenStore
extends SimpleTokenStore {
    private PersistenceManager pm = new PersistenceManager();

    public SecurityTokenStore() throws TrustException {
        SecurityTokenDO[] tokens = this.pm.getAllSecurityTokens();
        for (int i = 0; i < tokens.length; ++i) {
            SecurityTokenDO tokenDO = tokens[i];
            Token token = tokenDO.toToken();
            this.tokens.put(token.getId(), token);
        }
    }

    public void add(Token token) throws TrustException {
        String tokenId;
        if (token != null && token.getId() != null && (tokenId = token.getId().trim()).length() != 0 && this.getToken(tokenId) == null) {
            SecurityTokenDO tokenDO = new SecurityTokenDO(token.getId(), token.getToken(), token.getCreated(), token.getExpires());
            tokenDO.update(token);
            try {
                this.pm.addToken(tokenDO);
            }
            catch (TokenAlreadyExistsException e) {
                throw new TrustException("Token already exists", (Throwable)e);
            }
            this.tokens.put(tokenId, token);
        }
    }

    public void update(Token token) throws TrustException {
        if (token != null && token.getId() != null && token.getId().trim().length() != 0) {
            if (!this.tokens.keySet().contains(token.getId())) {
                throw new TrustException("noTokenToUpdate", (Object[])new String[]{token.getId()});
            }
            this.tokens.put(token.getId(), token);
            SecurityTokenDO tokenDO = this.pm.getSecurityToken(token.getId());
            tokenDO.update(token);
            this.pm.updateSecurityToken(tokenDO);
        }
    }
}

