/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.transport.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axiom.attachments.utils.IOUtils;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.ws.commons.schema.XmlSchema;
import org.wso2.utils.NetworkUtils;
import org.wso2.utils.ServerConfiguration;
import org.wso2.wsas.ServerManager;
import org.wso2.wsas.transport.util.RequestProcessorUtil;

public class XsdUtil {
    public static void printXsd(HttpServletRequest request, HttpServletResponse response, ConfigurationContext configCtx, String serviceName, AxisService axisService) throws IOException {
        ServletOutputStream outputStream = response.getOutputStream();
        String contextRoot = request.getContextPath();
        if (axisService != null) {
            if (!axisService.isActive()) {
                response.setContentType("text/html");
                outputStream.write(("<h4>Service " + serviceName + " is inactive. Cannot display Schema.</h4>").getBytes());
                outputStream.flush();
                return;
            }
            axisService.populateSchemaMappings();
            Map schemaMappingtable = axisService.getSchemaMappingTable();
            String xsds = request.getParameter("xsd");
            if (xsds != null && xsds.trim().length() != 0) {
                int dotIndex;
                response.setContentType("text/xml");
                XmlSchema schema = (XmlSchema)schemaMappingtable.get(xsds);
                if (schema == null && (dotIndex = xsds.indexOf(46)) > 0) {
                    String schemaKey = xsds.substring(0, dotIndex);
                    schema = (XmlSchema)schemaMappingtable.get(schemaKey);
                }
                if (schema != null) {
                    schema.write((Writer)new OutputStreamWriter((OutputStream)outputStream, "UTF8"));
                    outputStream.flush();
                    outputStream.close();
                } else {
                    InputStream in = axisService.getClassLoader().getResourceAsStream("META-INF/" + xsds);
                    if (in != null) {
                        outputStream.write(IOUtils.getStreamAsByteArray((InputStream)in));
                        outputStream.flush();
                        outputStream.close();
                    } else {
                        response.sendError(404);
                    }
                }
                return;
            }
            ArrayList schemas = axisService.getSchema();
            if (schemas.size() == 1) {
                response.setContentType("text/xml");
                XsdUtil.processSchema((XmlSchema)schemas.get(0), (OutputStream)outputStream, contextRoot, request);
            } else {
                String idParam = request.getParameter("id");
                if (idParam != null) {
                    XmlSchema schema = axisService.getSchema(Integer.parseInt(idParam));
                    if (schema != null) {
                        response.setContentType("text/xml");
                        XsdUtil.processSchema(schema, (OutputStream)outputStream, contextRoot, request);
                    } else {
                        response.setContentType("text/html");
                        outputStream.write("<h4>Schema not found!</h4>".getBytes());
                    }
                } else {
                    String ipAddress = "http://" + NetworkUtils.getLocalHostname() + ":" + ServerManager.getInstance().getHttpPort();
                    String version = ServerConfiguration.getInstance().getFirstProperty("Version");
                    outputStream.write(("<html><head><title>WSO2 Web Services Application Server v" + version + "Management Console" + " - " + axisService.getName() + " Service Schema</title>" + "</head>" + "<body>" + "<b>Schemas for " + axisService.getName() + " service</b><br/><br/>").getBytes());
                    if (schemas.size() != 0) {
                        for (int i = 0; i < schemas.size(); ++i) {
                            String st = "<a href=\"" + ipAddress + RequestProcessorUtil.getServiceContextPath(configCtx) + "/" + axisService.getName() + "?xsd&id=" + i + "&" + "annotation" + "=true" + "\">Schema " + i + "</a><br/>";
                            outputStream.write(st.getBytes());
                        }
                    } else {
                        outputStream.write("<p>No schemas found</p>".getBytes());
                    }
                    outputStream.write("</body></html>".getBytes());
                }
            }
        } else {
            response.setContentType("text/html");
            outputStream.write(("<h4>Service " + serviceName + " is not found. Cannot display Schema.</h4>").getBytes());
            outputStream.flush();
        }
    }

    private static void processSchema(XmlSchema schema, OutputStream outputStream, String contextRoot, HttpServletRequest request) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        schema.write((OutputStream)baos);
        RequestProcessorUtil.writeDocument(baos, outputStream, "annotated-xsd.xsl", contextRoot, XsdUtil.isXSDAnnotated(request));
    }

    private static boolean isXSDAnnotated(HttpServletRequest request) {
        String param = request.getParameter("annotation");
        return param != null && param.length() != 0 && param.equals("true");
    }
}

