/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.transport.util;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.engine.AxisConfiguration;
import org.wso2.wsas.util.SystemFilter;

public class ServiceHTMLProcessor {
    public static String getServicesHTML(ConfigurationContext configContext) {
        Hashtable erroneousServices;
        StringBuffer temp = new StringBuffer();
        Iterator serviceGroupsItr = configContext.getAxisConfiguration().getServiceGroups();
        boolean status = false;
        if (serviceGroupsItr.hasNext()) {
            status = true;
            temp.append("<h2>Deployed services</h2>");
            while (serviceGroupsItr.hasNext()) {
                AxisServiceGroup axisServiceGroup = (AxisServiceGroup)serviceGroupsItr.next();
                if (SystemFilter.isFilteredOutService(axisServiceGroup.getServiceGroupName())) continue;
                status = true;
                Iterator serviceItr = axisServiceGroup.getServices();
                while (serviceItr.hasNext()) {
                    AxisService axisService = (AxisService)serviceItr.next();
                    temp.append("<h3><a href=\"").append(axisService.getName()).append("?info\">").append(axisService.getName()).append("</a></h3>");
                }
            }
        }
        if ((erroneousServices = configContext.getAxisConfiguration().getFaultyServices()) != null && !erroneousServices.isEmpty()) {
            temp.append("<hr><h2><font color=\"blue\">Faulty Services</font></h2>");
            status = true;
            Enumeration faultyservices = erroneousServices.keys();
            while (faultyservices.hasMoreElements()) {
                String faultyserviceName = (String)faultyservices.nextElement();
                temp.append("<h3><font color=\"blue\">").append(faultyserviceName).append("</font></h3>");
            }
        }
        if (!status) {
            temp.append("<h2>There are no services deployed</h2>");
        }
        return "<html><head><title>Axis2: Services</title></head><body>" + temp + "</body></html>";
    }

    public static String printServiceHTML(String serviceName, ConfigurationContext configurationContext) {
        StringBuffer temp = new StringBuffer();
        try {
            AxisConfiguration axisConfig = configurationContext.getAxisConfiguration();
            AxisService axisService = axisConfig.getService(serviceName);
            if (axisService != null) {
                if (!axisService.isActive()) {
                    temp.append("<b>Service ").append(serviceName).append(" is inactive. Cannot display service information.</b>");
                } else {
                    temp.append("<h3>").append(axisService.getName()).append("</h3>");
                    temp.append("<a href=\"").append(axisService.getName()).append("?wsdl\">wsdl</a> : ");
                    temp.append("<a href=\"").append(axisService.getName()).append("?xsd\">schema</a> : ");
                    temp.append("<a href=\"").append(axisService.getName()).append("?policy\">policy</a><br/>");
                    temp.append("<i>Service Description :  ").append(axisService.getDocumentation()).append("</i><br/><br/>");
                    Iterator pubOpIter = axisService.getPublishedOperations().iterator();
                    while (pubOpIter.hasNext()) {
                        temp.append("Published operations <ul>");
                        while (pubOpIter.hasNext()) {
                            AxisOperation axisOperation = (AxisOperation)pubOpIter.next();
                            temp.append("<li>").append(axisOperation.getName().getLocalPart()).append("</li>");
                        }
                        temp.append("</ul>");
                    }
                }
            } else {
                temp.append("<b>Service ").append(serviceName).append(" not found. Cannot display service information.</b>");
            }
            return "<html><head><title>Service Information</title></head><body>" + temp + "</body></html>";
        }
        catch (AxisFault axisFault) {
            return "<html><head><title>Error Occurred</title></head><body><hr><h2><font color=\"blue\">" + axisFault.getMessage() + "</font></h2></body></html>";
        }
    }
}

