/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.transport.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RequestProcessorUtil {
    private static Log log = LogFactory.getLog((Class)RequestProcessorUtil.class);

    public static void writeDocument(ByteArrayOutputStream byteArrayOutStream, OutputStream out, String annotatedXsl, String contextRoot, boolean annotation) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(byteArrayOutStream.toByteArray());
            XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(bais);
            StAXOMBuilder builder = new StAXOMBuilder(reader);
            OMElement docElem = builder.getDocumentElement();
            XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(out);
            if (annotatedXsl != null && annotation) {
                writer.writeProcessingInstruction("xml-stylesheet", "  type=\"text/xsl\" href=\"" + (contextRoot.equals("/") ? "" : contextRoot) + "/styles/" + annotatedXsl + "\"");
            }
            docElem.serialize(writer);
            writer.flush();
        }
        catch (XMLStreamException e) {
            log.error((Object)"Error occurred while trying to write processing instruction for attaching annotated style sheet", (Throwable)e);
        }
    }

    public static String getServiceContextPath(ConfigurationContext configCtx) {
        String serviceContextPath = configCtx.getServiceContextPath();
        if (!configCtx.getContextRoot().equals("/") && !serviceContextPath.startsWith("/")) {
            serviceContextPath = "/" + serviceContextPath;
        }
        return serviceContextPath;
    }
}

