/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.transport.util;

import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.wsas.persistence.PersistenceManager;
import org.wso2.wsas.persistence.dataobject.KeyStoreDO;
import org.wso2.wsas.persistence.dataobject.ServiceDO;
import org.wso2.wsas.persistence.dataobject.TransportDO;
import org.wso2.wsas.transport.HttpGetRequestProcessor;
import org.wso2.wsas.util.KeyStoreUtil;

public class CertProcessor
implements HttpGetRequestProcessor {
    private static Log log = LogFactory.getLog((Class)CertProcessor.class);
    private static PersistenceManager pm = new PersistenceManager();

    public void process(HttpServletRequest request, HttpServletResponse response, ConfigurationContext configurationContext) throws Exception {
        String requestURI = request.getRequestURI();
        String contextPath = configurationContext.getServiceContextPath();
        String serviceName = requestURI.substring(requestURI.indexOf(contextPath) + contextPath.length() + 1);
        AxisService axisService = configurationContext.getAxisConfiguration().getServiceForActivation(serviceName);
        ServletOutputStream outputStream = response.getOutputStream();
        if (!axisService.isActive()) {
            response.setContentType("text/html");
            outputStream.write(("<h4>Service " + serviceName + " is inactive. Cannot retrieve certificate.</h4>").getBytes());
            outputStream.flush();
        } else {
            ServiceDO serviceDO = pm.getService(serviceName, null);
            KeyStoreDO privateKeyStore = serviceDO.getPrivateKeyStore();
            if (privateKeyStore == null) {
                Set set = serviceDO.getTransports();
                boolean httpsEnabled = false;
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    TransportDO transportDO = (TransportDO)iterator.next();
                    String transportProtocol = transportDO.getTransportProtocol();
                    if (!transportProtocol.equals("https")) continue;
                    httpsEnabled = true;
                    break;
                }
                if (httpsEnabled || serviceDO.getIsExposedOnAllTransports()) {
                    KeyStoreDO[] keyStoreDOs = pm.getKeyStores();
                    List<KeyStoreDO> list = Arrays.asList(keyStoreDOs);
                    Iterator<KeyStoreDO> iterator2 = list.iterator();
                    while (iterator2.hasNext()) {
                        KeyStoreDO keyStoreDO = iterator2.next();
                        if (!keyStoreDO.getIsPrimaryKeyStore()) continue;
                        Certificate cert = KeyStoreUtil.getCertificate(keyStoreDO.getKeyStoreName(), keyStoreDO.getPrivateKeyAlias());
                        this.serializeCert(cert, response, (OutputStream)outputStream, serviceName);
                        break;
                    }
                } else {
                    response.setContentType("text/html");
                    outputStream.write(("<h4>Service " + serviceName + " does not have a private key.</h4>").getBytes());
                    outputStream.flush();
                }
            } else {
                Certificate certificate = KeyStoreUtil.getCertificate(privateKeyStore.getKeyStoreName(), privateKeyStore.getPrivateKeyAlias());
                this.serializeCert(certificate, response, (OutputStream)outputStream, serviceName);
            }
        }
    }

    private void serializeCert(Certificate certificate, HttpServletResponse response, OutputStream outputStream, String serviceName) throws AxisFault {
        try {
            response.setContentType("application/octet-stream");
            response.setHeader("Content-Disposition", "filename=" + serviceName + ".cert");
            outputStream.write(certificate.getEncoded());
        }
        catch (CertificateEncodingException e) {
            String msg = "Could not get encoded format of certificate";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
        catch (IOException e) {
            String msg = "Faliour when serializing to stream";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
        finally {
            try {
                outputStream.flush();
            }
            catch (IOException e) {
                String msg = "Faliour when serializing to stream";
                log.error((Object)msg, (Throwable)e);
            }
        }
    }
}

