/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.transport.util;

import java.io.IOException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.wso2.wsas.transport.HttpGetRequestProcessor;

public abstract class AbstractWsdlProcessor
implements HttpGetRequestProcessor {
    protected void printWSDL(ConfigurationContext configurationContext, String serviceName, HttpServletResponse response, WSDLPrinter wsdlPrinter) throws IOException {
        AxisService axisService = configurationContext.getAxisConfiguration().getServiceForActivation(serviceName);
        ServletOutputStream outputStream = response.getOutputStream();
        if (axisService != null) {
            if (!axisService.isActive()) {
                response.setContentType("text/html");
                outputStream.write(("<h4>Service " + serviceName + " is inactive. Cannot display WSDL document.</h4>").getBytes());
                outputStream.flush();
            } else {
                response.setContentType("text/xml");
                wsdlPrinter.printWSDL(axisService);
            }
        } else {
            response.setContentType("text/html");
            outputStream.write(("<h4>Service " + serviceName + " not found. Cannot display WSDL document.</h4>").getBytes());
            outputStream.flush();
        }
    }

    protected boolean checkForAnnotation(HttpServletRequest request) {
        String parameter = request.getParameter("annotation");
        return parameter != null && parameter.length() != 0 && parameter.equals("true");
    }

    protected String getImportedWSDL(HttpServletRequest request, String paramName) {
        String paramValue = request.getParameter(paramName);
        if (paramValue != null && paramValue.length() != 0) {
            return paramValue;
        }
        return "";
    }

    protected static interface WSDLPrinter {
        public void printWSDL(AxisService var1) throws IOException;
    }
}

