/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.transport.http;

import java.io.File;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.description.Parameter;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.Embedded;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.util.IntrospectionUtils;
import org.wso2.utils.transport.AbstractTransportListener;
import org.wso2.utils.transport.ProxyCache;
import org.wso2.wsas.ServerConstants;
import org.wso2.wsas.ServerManager;
import org.wso2.wsas.TomcatServerCache;

public class HttpsTransportListener
extends AbstractTransportListener {
    private static Log log = LogFactory.getLog((Class)HttpsTransportListener.class);
    private Connector connector;
    private boolean isStarted;

    public EndpointReference getEPRForService(String serviceName, String ip) throws AxisFault {
        return this.getEPR("https", serviceName, ip);
    }

    public EndpointReference[] getEPRsForService(String serviceName, String ip) throws AxisFault {
        return new EndpointReference[]{this.getEPRForService(serviceName, ip)};
    }

    public synchronized void start() throws AxisFault {
        if (this.isStarted) {
            return;
        }
        ServerManager.getInstance().setHttpsPort(this.port);
        Embedded embedded = TomcatServerCache.getEmbedded();
        try {
            if (this.connector == null) {
                this.connector = embedded.createConnector((InetAddress)null, this.port, true);
                this.connector.setScheme("https");
                ArrayList parameters = this.tInDescription.getParameters();
                Iterator iterator = parameters.iterator();
                while (iterator.hasNext()) {
                    Parameter parameter = (Parameter)iterator.next();
                    String name = parameter.getName();
                    if (name.equals("keystore")) continue;
                    this.connector.setAttribute(name, parameter.getValue());
                }
                OMElement ksEle = this.tInDescription.getParameter("keystore").getParameterElement().getFirstElement();
                String ksLocation = ksEle.getFirstChildWithName(ServerConstants.Security.LOCATION).getText();
                String absKsLocation = !new File(ksLocation).isAbsolute() ? new File(System.getProperty("wso2wsas.home") + File.separator + ksLocation).getAbsolutePath() : ksLocation;
                String ksPassword = ksEle.getFirstChildWithName(ServerConstants.Security.PASSWORD).getText();
                IntrospectionUtils.setProperty((Object)this.connector, (String)"keypass", (String)ksPassword);
                IntrospectionUtils.setProperty((Object)this.connector, (String)"keystore", (String)absKsLocation);
                this.connector.setEnableLookups(true);
                this.connector.setSecure(true);
                TomcatServerCache.addConnector(this.connector);
                ProxyCache.getInstance().setHttpsPort(this.proxyPort);
            }
            this.connector.start();
            this.isStarted = true;
        }
        catch (Exception e) {
            embedded.removeConnector(this.connector);
            String msg = "Exception occurred while starting the Tomcat SSL connector";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
    }

    public synchronized void stop() throws AxisFault {
        if (!this.isStarted) {
            return;
        }
        log.info((Object)"Stopping HTTPS transport...");
        try {
            if (this.connector.isAvailable()) {
                this.connector.stop();
            }
            this.isStarted = false;
        }
        catch (LifecycleException e) {
            String msg = "Cannot stop Tomcat HTTP connector";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
    }
}

