/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.transport.http;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.description.Parameter;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.Embedded;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.utils.transport.AbstractTransportListener;
import org.wso2.utils.transport.ProxyCache;
import org.wso2.wsas.TomcatServerCache;

public class HttpTransportListener
extends AbstractTransportListener {
    private static Log log = LogFactory.getLog((Class)HttpTransportListener.class);
    private boolean isStarted;
    private Connector connector;

    public EndpointReference getEPRForService(String serviceName, String ip) throws AxisFault {
        return this.getEPR("http", serviceName, ip);
    }

    public EndpointReference[] getEPRsForService(String serviceName, String ip) throws AxisFault {
        return new EndpointReference[]{this.getEPRForService(serviceName, ip)};
    }

    public synchronized void start() throws AxisFault {
        if (this.isStarted) {
            return;
        }
        Embedded embedded = TomcatServerCache.getEmbedded();
        try {
            if (this.connector == null) {
                this.connector = embedded.createConnector((InetAddress)null, this.port, false);
                this.connector.setEnableLookups(true);
                ArrayList parameters = this.tInDescription.getParameters();
                Iterator iterator = parameters.iterator();
                while (iterator.hasNext()) {
                    Parameter parameter = (Parameter)iterator.next();
                    this.connector.setAttribute(parameter.getName(), parameter.getValue());
                }
                TomcatServerCache.addConnector(this.connector);
                ProxyCache.getInstance().setHttpPort(this.proxyPort);
            }
            this.connector.start();
            this.isStarted = true;
        }
        catch (Exception e) {
            embedded.removeConnector(this.connector);
            String msg = "Exception occurred while starting the Tomcat HTTP connector";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
    }

    public synchronized void stop() throws AxisFault {
        if (!this.isStarted) {
            return;
        }
        log.info((Object)"Stopping HTTP transport...");
        try {
            if (this.connector.isAvailable()) {
                this.connector.stop();
            }
            this.isStarted = false;
        }
        catch (LifecycleException e) {
            String msg = "Cannot stop Tomcat HTTP connector";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
    }
}

