/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.transport.http;

import java.net.SocketException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.SessionContext;
import org.apache.axis2.transport.TransportListener;
import org.wso2.utils.NetworkUtils;
import org.wso2.utils.SessionContextUtil;

public abstract class AbstractGenericTransportListener
implements TransportListener {
    protected int proxyPort = -1;
    protected ConfigurationContext configurationContext;

    public AbstractGenericTransportListener() {
    }

    public AbstractGenericTransportListener(ConfigurationContext configurationContext) {
        this.configurationContext = configurationContext;
    }

    public void destroy() {
        this.configurationContext = null;
    }

    public SessionContext getSessionContext(MessageContext messageContext) {
        return SessionContextUtil.createSessionContext((MessageContext)messageContext);
    }

    public void stop() throws AxisFault {
    }

    protected EndpointReference genEpr(String protocol, String ip, int port, String serviceContextPath, String serviceName) throws AxisFault {
        try {
            if (ip == null) {
                ip = NetworkUtils.getLocalHostname();
            }
            String tmp = protocol + "://" + ip;
            if (this.proxyPort == 80 || this.proxyPort == 443) {
                tmp = tmp + serviceContextPath + "/" + serviceName;
                return new EndpointReference(tmp);
            }
            if (this.proxyPort > -1) {
                tmp = tmp + ":" + this.proxyPort + serviceContextPath + "/" + serviceName;
                return new EndpointReference(tmp);
            }
            tmp = tmp + ":" + port + serviceContextPath + "/" + serviceName;
            return new EndpointReference(tmp);
        }
        catch (SocketException e) {
            throw AxisFault.makeFault((Throwable)e);
        }
    }
}

