/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.transport.fileupload;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.collections.bidimap.TreeBidiMap;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.servlet.ServletRequestContext;
import org.wso2.utils.ServerConfiguration;
import org.wso2.utils.ServerException;
import org.wso2.wsas.transport.fileupload.AbstractFileUploadExecutor;
import org.wso2.wsas.util.WsasUtils;

public class SpringFileUploadExecutor
extends AbstractFileUploadExecutor {
    public SpringFileUploadExecutor(ConfigurationContext configurationContext) {
        super(configurationContext);
    }

    public boolean execute(HttpServletRequest request, HttpServletResponse response) throws ServerException, IOException {
        ServletRequestContext servletRequestContext;
        boolean isMultipart;
        PrintWriter out = response.getWriter();
        String axis2Repo = ServerConfiguration.getInstance().getFirstProperty("Axis2Config.RepositoryLocation");
        if (WsasUtils.isURL(axis2Repo)) {
            out.write("<script language=\"javascript\">top.wso2.wsf.Util.alertWarning('You are not permitted to upload services to URL repository " + axis2Repo + "');" + "</script>");
            out.flush();
            return false;
        }
        response.setContentType("text/html; charset=utf-8");
        String[] uuids = new String[2];
        Map fileResourceMap = (Map)this.configurationContext.getProperty("file.resource.map");
        if (fileResourceMap == null) {
            fileResourceMap = new TreeBidiMap();
            this.configurationContext.setProperty("file.resource.map", (Object)fileResourceMap);
        }
        if (isMultipart = ServletFileUpload.isMultipartContent((RequestContext)(servletRequestContext = new ServletRequestContext(request)))) {
            try {
                List items = this.parseRequest(servletRequestContext);
                Iterator iter = items.iterator();
                while (iter.hasNext()) {
                    File uploadedFile;
                    File servicesDir;
                    String serviceUploadDir;
                    String uuid;
                    String fileName;
                    FileItem item = (FileItem)iter.next();
                    if (item.isFormField()) continue;
                    String fileExtension = fileName = item.getName();
                    fileExtension = fileExtension.toLowerCase();
                    String fieldName = item.getFieldName();
                    String fileNameOnly = this.getFileName(fileName);
                    if (fieldName.trim().equals("springBeans")) {
                        uuid = String.valueOf((double)System.currentTimeMillis() + Math.random());
                        serviceUploadDir = this.configurationContext.getProperty("WORK_DIR") + File.separator + "spring" + File.separator + uuid + File.separator;
                        if (fileExtension.endsWith(".jar")) {
                            servicesDir = new File(serviceUploadDir);
                            servicesDir.mkdirs();
                            uploadedFile = new File(servicesDir, fileNameOnly);
                            uuids[0] = uuid;
                            fileResourceMap.put(uuid, uploadedFile.getAbsolutePath());
                            item.write(uploadedFile);
                        }
                    }
                    if (!fieldName.trim().equals("springContext")) continue;
                    uuid = String.valueOf((double)System.currentTimeMillis() + Math.random());
                    serviceUploadDir = this.configurationContext.getProperty("WORK_DIR") + File.separator + "spring" + File.separator + uuid + File.separator;
                    servicesDir = new File(serviceUploadDir);
                    servicesDir.mkdirs();
                    uploadedFile = new File(servicesDir, fileNameOnly);
                    uuids[1] = uuid;
                    fileResourceMap.put(uuid, uploadedFile.getAbsolutePath());
                    item.write(uploadedFile);
                }
                out.write("<script language=\"javascript\">top.getSpringBeansFromArchive('" + uuids[0] + "','" + uuids[1] + "');" + "</script>");
                return true;
            }
            catch (Exception e) {
                log.error((Object)"File upload failed", (Throwable)e);
                out.write("<script language=\"javascript\">top.wso2.wsf.Util.alertWarning('Service file upload FAILED. " + e.getMessage() + "');" + "</script>");
            }
        }
        return false;
    }
}

