/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.transport.fileupload;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.engine.AxisConfiguration;
import org.wso2.utils.ServerConfiguration;
import org.wso2.utils.ServerException;
import org.wso2.wsas.transport.fileupload.AbstractFileUploadExecutor;
import org.wso2.wsas.util.WsasUtils;

public class ModuleFileUploadExecutor
extends AbstractFileUploadExecutor {
    public ModuleFileUploadExecutor(ConfigurationContext configurationContext) {
        super(configurationContext);
    }

    public boolean execute(HttpServletRequest request, HttpServletResponse response) throws ServerException, IOException {
        File uploadedFile;
        String axis2Repo = ServerConfiguration.getInstance().getFirstProperty("Axis2Config.RepositoryLocation");
        PrintWriter out = response.getWriter();
        if (WsasUtils.isURL(axis2Repo)) {
            out.write("<script language=\"javascript\">top.wso2.wsf.Util.alertWarning('You are not permitted to upload modules to URL repository " + axis2Repo + "');" + "</script>");
            out.flush();
            return false;
        }
        AxisConfiguration axisConfiguration = this.configurationContext.getAxisConfiguration();
        String repo = axisConfiguration.getRepository().getPath();
        if (repo == null) {
            throw new ServerException("no repository found to deploy the service");
        }
        File moduledir = new File(repo, "modules");
        if (!moduledir.exists()) {
            moduledir.mkdir();
        }
        if ((uploadedFile = this.uploadFile(request, moduledir.getAbsolutePath(), response, ".mar")) != null) {
            try {
                AxisModule axisModule = DeploymentEngine.buildModule((File)uploadedFile, (AxisConfiguration)axisConfiguration);
                axisConfiguration.addModule(axisModule);
                out.write("<script language=\"javascript\">top.listModules();var restart= confirm(\"Module was uploaded successfuly to the repository.\" +\n                        \"\\n The server needs to be restarted for this to take effect.\" +\n                        \"\\n Restart now?\");\nif (restart) {\n   top.stopWaitAnimation()   ;\n   top.wso2.wsf.Util.restartServer();\n}</script>");
            }
            catch (Exception e) {
                out.write("<script language=\"javascript\">top.wso2.wsf.Util.alertWarning('Exception occurred during module upload. Reason : " + e + "');" + "top.listModules();" + "</script>");
            }
            out.flush();
        }
        return true;
    }
}

